% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmt-utils.R
\name{gmt2mat}
\alias{gmt2mat}
\title{Convert GMT to Binary Matrix}
\usage{
gmt2mat(
  gmt,
  max.genes = -1,
  ntop = -1,
  sparse = TRUE,
  bg = NULL,
  use.multicore = TRUE
)
}
\arguments{
\item{gmt}{List representing the GMT file: each element is a character vector representing a gene set.}

\item{max.genes}{Max number of genes to include in the binary matrix. Default = -1 to include all genes.}

\item{ntop}{Number of top genes to consider for each gene set. Default = -1 to include all genes.}

\item{sparse}{Logical: create a sparse matrix. Default \code{TRUE}. If \code{FALSE} creates a dense matrix.}

\item{bg}{Character vector of background gene set. Default \code{NULL} to consider all unique genes.}

\item{use.multicore}{Logical: use parallel processing ('parallel' R package). Default \code{TRUE}.}
}
\value{
A binary matrix representing the presence or absence of genes in each gene set.
Rows correspond to genes, and columns correspond to gene sets.
}
\description{
Convert a GMT file (Gene Matrix Transposed) to a binary matrix,
where rows represent genes and columns represent gene sets.
The binary matrix indicates presence or absence of genes in a gene set.
}
\examples{
# Create example GMT data
gmt <- list(
  "Pathway1" = c("GENE1", "GENE2", "GENE3"),
  "Pathway2" = c("GENE2", "GENE4", "GENE5"),
  "Pathway3" = c("GENE1", "GENE5", "GENE6")
)

# Convert to binary matrix
mat <- gmt2mat(gmt)
print(mat)

# Create dense matrix instead of sparse
mat_dense <- gmt2mat(gmt, sparse = FALSE)
print(mat_dense)
}
