% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{dualGSEA}
\alias{dualGSEA}
\title{Reimplementation of dualGSEA (Bull et al., 2024) but defaults with
replaid backend. For the preranked test we still use fgsea. Should
be much faster than original using fgsea + GSVA::ssGSEA.}
\usage{
dualGSEA(
  X,
  y,
  G,
  gmt = NULL,
  gsetX = NULL,
  fc.method = c("fgsea", "rankcor", "ztest", "ttest", "cor")[2],
  ss.method = c("plaid", "replaid.ssgsea", "replaid.gsva", "ssgsea", "gsva")[1],
  metap.method = c("stouffer", "fisher", "maxp")[1],
  pv1 = NULL,
  pv2 = NULL,
  sort.by = "p.dual"
)
}
\arguments{
\item{X}{Expression matrix with genes on rows and samples ont columns}

\item{y}{Binary vector (0/1) indicating group membership}

\item{G}{Sparse matrix of gene sets. Non-zero entry indicates
gene/feature is part of gene sets. Features on rows, gene sets on
columns.}

\item{gmt}{List of gene sets in GMT format}

\item{gsetX}{Optional pre-computed matrix of gene set enrichment scores with
gene sets on rows and samples on columns. If NULL (default), scores will be
computed using the method specified by \code{ss.method}. Providing pre-computed
scores improves efficiency when running multiple analyses.}

\item{fc.method}{Method for fold change testing ("fgsea", "ztest", "ttest", "rankcor", "cor")}

\item{ss.method}{Method for single-sample enrichment ("plaid", "replaid.ssgsea", "replaid.gsva", "ssgsea", "gsva")}

\item{metap.method}{Method for combining p-values ("stouffer", "fisher" or "maxp"). Default "stouffer".}

\item{pv1}{Pre-computed p-values from fold change test. If NULL, will be computed based on fc.test.}

\item{pv2}{Pre-computed p-values from single sample test. If NULL, will be computed using gset_ttest.}

\item{sort.by}{Column name to sort results by ("p.dual", "gsetFC", "p.fc", "p.ss"). Default "p.dual".}
}
\value{
Data frame with columns: gsetFC (gene set fold change), size (gene set size),
p.fc (p-value from fold change test), p.ss (p-value from single sample test),
p.dual (combined p-value), and q.dual (FDR-adjusted combined p-value).
}
\description{
Reimplementation of dualGSEA (Bull et al., 2024) but defaults with
replaid backend. For the preranked test we still use fgsea. Should
be much faster than original using fgsea + GSVA::ssGSEA.
}
\examples{
# Create example expression matrix
set.seed(123)
X <- matrix(rnorm(1000), nrow = 100, ncol = 20)
rownames(X) <- paste0("GENE", 1:100)
colnames(X) <- paste0("Sample", 1:20)

# Create binary group vector
y <- rep(c(0, 1), each = 10)

# Create example gene sets
gmt <- list(
  "Pathway1" = paste0("GENE", 1:20),
  "Pathway2" = paste0("GENE", 15:35),
  "Pathway3" = paste0("GENE", 30:50)
)

# Perform dualGSEA with correlation test (fast method)
results_cor <- dualGSEA(X, y, G = NULL, gmt = gmt, fc.method = "cor", ss.method = "replaid.gsva")
print(head(results_cor))

\donttest{
# Perform dualGSEA with fgsea (requires fgsea package)
if (requireNamespace("fgsea", quietly = TRUE)) {
  results <- dualGSEA(X, y, G = NULL, gmt = gmt, fc.method = "fgsea", ss.method = "replaid.ssgsea")
  print(head(results))
}
}

}
