% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dea_evaluationFunctions.R
\name{dea_evalPlot_curve}
\alias{dea_evalPlot_curve}
\title{dea_evalPlot_curve}
\usage{
dea_evalPlot_curve(
  res,
  scales = "free",
  agg.by = NULL,
  agg.fn = mean,
  xlim = c(NA, NA),
  colourBy = "method",
  shapeBy = NULL,
  pointsize = 4
)
}
\arguments{
\item{res}{Aggregated results of the DEA pipeline}

\item{scales}{Passed to `facet_grid`}

\item{agg.by}{Aggregate results by these columns (default no aggregation)}

\item{agg.fn}{Function for aggregation (default mean)}

\item{xlim}{Optional vector of x limits}

\item{colourBy}{Name of column by which to colour}

\item{shapeBy}{Name of column determining the shape of the points. If 
omitted, the shape will indicate whether the nominal FDR is below or equal 
the real FDR.}

\item{pointsize}{Size of the points}
}
\value{
A ggplot.
}
\description{
dea_evalPlot_curve
}
\examples{
data("exampleDEAresults", package="pipeComp")
dea_evalPlot_curve(exampleDEAresults, agg.by=c("sva.method"))
}
