#' @rdname ctrlgenes
#' @name ctrlgenes
#' @aliases ctrlgenes
#'
#' @title Lists of control genes
#'
#' @description
#' Lists of mouse and human control genes (mitochondrial, ribosomal, 
#' protein-coding), as ensembl gene ids or official symbols, for computing cell
#'  QC.
#'
#' @return a list.
NULL


#' @rdname clustMetricsCorr
#' @name clustMetricsCorr
#' @references 
#' See https://doi.org/10.1101/2020.02.02.930578
#' @aliases clustMetricsCorr
#'
#' @title Correlations across clustering evaluation metrics
#'
#' @description
#' A list of two matrices containing, respectively, the Pearson and Spearman
#' pairwise correlations between various clustering evalution metrics, computed
#' across a wide range of scRNAseq clustering analyses (see reference).
#'
#' @return a list.
NULL


#' @rdname exampleResults
#' @name exampleResults
#' @aliases exampleResults
#'
#' @title Example pipeline results
#'
#' @description
#' Example benchmarking results from a scRNAseq pipeline (see vignette 
#' `pipeComp_scRNA`).
#'
#' @return a list.
NULL

#' @rdname exampleDEAresults
#' @name exampleDEAresults
#' @aliases exampleDEAresults
#'
#' @title Example results from the DEA pipeline
#'
#' @description
#' Example benchmarking results from a DEA pipeline (see vignette 
#' `pipeComp_dea`).
#'
#' @return a list.
NULL

#' @rdname stableG
#' @name stableG
#' @aliases stableG
#'
#' @title Lists of stable genes
#'
#' @description
#' Genes were simply obtained by querying the respective GO terms
#'
#' @return a list.
NULL


