% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_utils.R
\name{name_nodenumber_conversion}
\alias{name_nodenumber_conversion}
\alias{nn.to.name}
\alias{name.to.nn}
\title{Convert between node/tip labels and integer node numbers}
\usage{
nn.to.name(tr, x)

name.to.nn(tr, x)
}
\arguments{
\item{tr}{object of type \code{phylo}}

\item{x}{vector of numerics or characters}
}
\value{
vector
}
\description{
Useful if you want to convert between node labels (\code{c}), tip labels
(\code{t}) and the internal integer number that identifies that node
(\code{nn}). Particularly for use with plotting libraries.
}
\examples{
tr <- named_rtree(5)
name.to.nn(tr, 'n1')
name.to.nn(tr,c('n1','n2','t1'))
nn.to.name(tr, 1:9)
}
