% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractSignalRawData.R
\name{extractSignalRawData}
\alias{extractSignalRawData}
\title{Extract signal in a multiple defined mz rt window from a raw data file}
\usage{
extractSignalRawData(rawSpec, rt, mz, msLevel = 1L, verbose = TRUE)
}
\arguments{
\item{rawSpec}{an \code{\link[MSnbase]{OnDiskMSnExp-class}}}

\item{rt}{(numeric(2) or two-column matrix) the lower and upper retention
time range from which the data should be extracted. If a matrix is passed,
each row corresponds to a different window. If not provided, the full
retention time range will be extracted.}

\item{mz}{(numeric(2) or two-column matrix) the lower and upper mass range
from which the data should be extracted. If a matrix is passed, each row
corresponds to a different window. If not provided, the full mass range will
be extracted.}

\item{msLevel}{(int) the MS level at which the data should be extracted
(default to MS level 1)}

\item{verbose}{(bool) If TRUE message progress and warnings}
}
\value{
a list (one entry per window) of data.frame with signal as row and
retention time ('rt'), mass ('mz') and intensity ('int) as columns.
}
\description{
Extract all signal from multiple defined mz rt window from raw
data and returns a data.frame. If no rt-mz window is provided, all signal in
the raw data file are returned
}
\details{
## Examples cannot be computed as the function is not exported:
## Use a file form the faahKO package and extract data from a region of
## interest
library(faahKO)
rawSpec <- MSnbase::readMSData(
                            system.file('cdf/KO/ko15.CDF',package='faahKO'),
                            centroided=TRUE,
                            mode='onDisk')
dataPoints  <- extractSignalRawData(rawSpec,
                                    rt = c(3290., 3410.), 
                                    mz = c(522.194778, 522.205222), 
                                    verbose=TRUE)
# Reading data from 1 windows

dataPoints
# [[1]]
#          rt    mz    int
# 1  3290.115 522.2   1824
# 2  3291.680 522.2   1734
# 3  3293.245 522.2   1572
# 4  3294.809 522.2   1440
# 5  3299.504 522.2   1008
# 6  3301.069 522.2    871
# 7  3302.634 522.2    786
# 8  3304.199 522.2    802
# 9  3305.764 522.2    834
# 10 3307.329 522.2    839
# 11 3315.154 522.2   2187
# 12 3316.719 522.2   3534
# 13 3318.284 522.2   6338
# 14 3319.849 522.2  11718
# 15 3321.414 522.2  21744
# 16 3322.979 522.2  37872
# 17 3324.544 522.2  62424
# 18 3326.109 522.2  98408
# 19 3327.673 522.2 152896
# 20 3329.238 522.2 225984
# 21 3330.803 522.2 308672
# 22 3332.368 522.2 399360
# 23 3333.933 522.2 504000
# 24 3335.498 522.2 614656
# 25 3337.063 522.2 711872
# 26 3338.628 522.2 784704
# 27 3340.193 522.2 836608
# 28 3341.758 522.2 866304
# 29 3343.323 522.2 882304
# 30 3344.888 522.2 889280
# 31 3346.453 522.2 888256
# 32 3348.018 522.2 866816
# 33 3349.583 522.2 827392
# 34 3351.148 522.2 777728
# 35 3352.713 522.2 727040
# 36 3354.278 522.2 678464
# 37 3355.843 522.2 629120
# 38 3357.408 522.2 578048
# 39 3358.973 522.2 524288
# 40 3360.538 522.2 471040
# 41 3362.102 522.2 416320
# 42 3363.667 522.2 360064
# 43 3365.232 522.2 302400
# 44 3366.797 522.2 249152
# 45 3368.362 522.2 202560
# 46 3369.927 522.2 161024
# 47 3371.492 522.2 123520
# 48 3373.057 522.2  93160
# 49 3374.622 522.2  71856
# 50 3376.187 522.2  58392
# 51 3377.752 522.2  51072
# 52 3379.317 522.2  48376
# 53 3380.882 522.2  49168
# 54 3382.447 522.2  53120
# 55 3384.012 522.2  62488
# 56 3385.577 522.2  78680
# 57 3387.142 522.2 102840
# 58 3388.707 522.2 134656
# 59 3390.272 522.2 173440
# 60 3391.837 522.2 217088
# 61 3393.402 522.2 268864
# 62 3394.966 522.2 330496
# 63 3396.531 522.2 395776
# 64 3398.096 522.2 453376
# 65 3399.661 522.2 499072
# 66 3401.226 522.2 537024
# 67 3402.791 522.2 570304
# 68 3404.356 522.2 592512
# 69 3405.921 522.2 598912
# 70 3407.486 522.2 595008
# 71 3409.051 522.2 588416
}
