% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppiPlotNetwork.R
\name{ppiPlotNetwork}
\alias{ppiPlotNetwork}
\title{Plot an undirected PPI network using ggraph}
\usage{
ppiPlotNetwork(
  network,
  networkLayout = "nicely",
  title = NA,
  nodeSize = c(2, 6),
  fillColumn,
  fillType,
  catFillColours = "Set1",
  foldChangeColours = c("firebrick3", "#188119"),
  intColour = "grey70",
  nodeBorder = "grey30",
  hubColour = "blue2",
  subnetwork = TRUE,
  legend = FALSE,
  legendTitle = NULL,
  edgeColour = "grey40",
  edgeAlpha = 0.5,
  edgeWidth = 0.5,
  label = FALSE,
  labelColumn,
  labelFilter = 5,
  labelSize = 4,
  labelColour = "black",
  labelFace = "bold",
  labelPadding = 0.25,
  minSegLength = 0.25
)
}
\arguments{
\item{network}{A \code{tidygraph} object, output from \code{ppiBuildNetwork}}

\item{networkLayout}{Layout of nodes in the network. Supports all layouts
from \code{ggraph}/\code{igraph}, or a data frame of x and y coordinates for
each node (order matters!).}

\item{title}{Optional title for the plot (NA)}

\item{nodeSize}{Length-two numeric vector, specifying size range of node
sizes (maps to node degree). Default is \code{c(2, 6)}.}

\item{fillColumn}{Tidy-select column for mapping node colour. Designed to
handle continuous numeric mappings (either positive/negative only, or
both), and categorical mappings, plus a special case for displaying fold
changes from, for example, RNA-Seq data. See \code{fillType} for more details
on how to set this up.}

\item{fillType}{String denoting type of fill mapping to perform for nodes.
Options are: "foldChange", "twoSided", "oneSided", or "categorical".}

\item{catFillColours}{Colour palette to be used when \code{fillType} is set
to "categorical." Defaults to "Set1" from RColorBrewer. Will otherwise be
passed as the "values" argument in \code{scale_fill_manual()}.}

\item{foldChangeColours}{A two-length character vector containing colours
for up and down regulated genes. Defaults to \code{c("firebrick3", "#188119")}.}

\item{intColour}{Fill colour for non-seed nodes, i.e. interactors. Defaults
to "grey70".}

\item{nodeBorder}{Colour (stroke or outline) of all nodes in the network.
Defaults to "grey30".}

\item{hubColour}{Colour of node labels for hubs. The top 2\% of nodes
(based on calculated hub score) are highlighted with this colour, if
\code{label=TRUE}.}

\item{subnetwork}{Logical determining if networks from
\code{ppiExtractSubnetwork()} should be treated as such. Defaults to TRUE.}

\item{legend}{Should a legend be included? Defaults to FALSE.}

\item{legendTitle}{Optional title for the legend, defaults to \code{NULL}.}

\item{edgeColour}{Edge colour, defaults to "grey40"}

\item{edgeAlpha}{Transparency of edges, defaults to 0.5}

\item{edgeWidth}{Thickness of edges connecting nodes. Defaults to 0.5}

\item{label}{Boolean, whether labels should be added to nodes. Defaults to
FALSE.}

\item{labelColumn}{Tidy-select column of the network/data to be used in
labeling nodes. Recommend setting to \code{hgncSymbol}, which contains HGNC
symbols mapped from the input Ensembl IDs via biomaRt.}

\item{labelFilter}{Degree filter used to determine which nodes should be
labeled. Defaults to 5. This value can be increased to reduce the number of
node labels, to prevent the network from being too crowded.}

\item{labelSize}{Size of node labels, defaults to 5.}

\item{labelColour}{Colour of node labels, defaults to "black"}

\item{labelFace}{Font face for node labels, defaults to "bold"}

\item{labelPadding}{Padding around the label, defaults to 0.25 lines.}

\item{minSegLength}{Minimum length of lines to be drawn from labels to
points. The default specified here is 0.25, half of the normal default
value.}
}
\value{
A Protein-Protein Interaction (PPI) network plot; an object of class
"ggplot"
}
\description{
Visualize a protein-protein interaction (PPI) network using
\code{ggraph} functions, output from \code{ppiBuildNetwork}.
}
\details{
Any layout supported by ggraph can be specified here - see
\code{?layout_tbl_graph_igraph} for a list of options. Or you can supply a data
frame containing coordinates for each node. The first and second columns
will be used for x and y, respectively. Note that having columns named "x"
and "y" in the input network will generate a warning message when supplying
custom coordinates.

Since this function returns a standard ggplot object, you can tweak the
final appearance using the normal array of ggplot2 function, e.g. \code{labs()}
and \code{theme()} to further customize the final appearance.

The \code{fillType} argument will determine how the node colour is mapped to
the desired column. "foldChange" represents a special case, where the fill
column is numeric and whose values should be mapped to up (> 0) or down (<
0). "twoSided" and "oneSided" are designed for numeric data that contains
either positive and negative values, or only positive/negative values,
respectively. "categorical" handles any other non-numeric colour mapping,
and uses "Set1" from RColorBrewer.

Node statistics (degree, betweenness, and hub score) are calculated using
the respective functions from the \code{tidygraph} package.
}
\examples{
data("exampleDESeqResults")

exNetwork <- ppiBuildNetwork(
    rnaseqResult=exampleDESeqResults[[1]],
    filterInput=TRUE,
    order="zero"
)

ppiPlotNetwork(
    network=exNetwork,
    title="COVID positive over time",
    fillColumn=LogFoldChange,
    fillType="foldChange",
    legend=TRUE,
    label=FALSE
)

}
\seealso{
\url{https://github.com/hancockinformatics/pathlinkR/}
}
