% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppiExtractSubnetwork.R
\name{ppiExtractSubnetwork}
\alias{ppiExtractSubnetwork}
\title{Extract a subnetwork based on pathway genes}
\usage{
ppiExtractSubnetwork(
  network,
  genes = NULL,
  pathwayEnrichmentResult = NULL,
  pathwayToExtract
)
}
\arguments{
\item{network}{Input network object; output from \code{ppiBuildNetwork()}}

\item{genes}{Character vector of Ensembl gene IDs to use as the starting
point to extract a subnetwork from the initial network. You must provide
either the \code{genes} or \code{pathwayEnrichmentResult} argument.}

\item{pathwayEnrichmentResult}{Pathway enrichment result, output from
\code{ppiEnrichNetwork}. You must provide either \code{genes} or
\code{pathwayEnrichmentResult} argument.}

\item{pathwayToExtract}{Name of the pathway determining what genes (nodes)
are pulled from the input network. Must be present in the "pathwayName"
column of \code{pathwayEnrichmentResults}.}
}
\value{
A Protein-Protein Interaction (PPI) network; a "tidygraph" object for
plotting or further analysis, with the minimum set of columns for nodes
(additional columns from the input will also be included):
\item{name}{Ensembl gene ID for the node}
\item{degree}{Degree of the node, i.e. the number of interactions}
\item{betweenness}{Betweenness measure for the node}
\item{seed}{TRUE when the node was part of the input list of genes}
\item{hubScore}{Special hubScore for each node. The suffix denotes the
measure being used; e.g. "hubScoreBtw" is for betweenness}
\item{hgncSymbol}{HGNC gene name for the node}

Additionally the following columns are provided for edges:
\item{from}{Starting node for the interaction/edge as a row number}
\item{to}{Ending node for the interaction/edge as a row number}
}
\description{
Extract a subnetwork based on pathway genes
}
\details{
Uses functions from the igraph package to extract a minimally
connected subnetwork from the starting network, using either a list of
Ensembl genes or genes from an enriched pathway as the basis. To see what
genes were pulled out for the pathway, see the "starters" attribute of the
output network.
}
\examples{
data("exampleDESeqResults")

exNetwork <- ppiBuildNetwork(
    rnaseqResult=exampleDESeqResults[[1]],
    filterInput=TRUE,
    order="zero"
)

exPathways <- ppiEnrichNetwork(
    network=exNetwork,
    analysis="hallmark"
)

ppiExtractSubnetwork(
    network=exNetwork,
    pathwayEnrichmentResult=exPathways,
    pathwayToExtract="INTERFERON ALPHA RESPONSE"
)

}
\references{
Code for network module (subnetwork) extraction was based off of
that used in "jboktor/NetworkAnalystR" on Github.
}
\seealso{
\url{https://github.com/hancockinformatics/pathlinkR}
}
