% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictExternal.R
\name{predictExternal}
\alias{predictExternal}
\title{Predict conditions in external datasets}
\usage{
predictExternal(
  testData,
  model,
  realValues = NULL,
  positiveClass = NULL,
  use.assay = 1
)
}
\arguments{
\item{testData}{Numerical matrix or data frame with the same features used
for the model construction in rows, and the samples (new observations) in
columns. An ExpressionSet may or SummarizedExperiment may also be used.}

\item{model}{trainModel output or a caret-like model object}

\item{realValues}{Optional, named vector (for numerical variables) or
named factor (for categorical variables) with real values for each sample}

\item{positiveClass}{Optional, positive class to get confusion matrix.
Only needed when realValues = TRUE and for categorical variables}

\item{use.assay}{If SummarizedExperiments are used, the number of the assay 
to extract the data.}
}
\value{
A dataframe with predictions (if realValues
is not provided) or a list with the dataframe with predictions and a
dataframe with the performance metrics (if realValues is provided)
}
\description{
Predict conditions in external datasets
}
\examples{
data(refData)

commonGenes <- intersect(rownames(refData$dataset1),
                         rownames(refData$dataset2))
dataset1 <- refData$dataset1[commonGenes, ]
dataset2 <- refData$dataset2[commonGenes, ]

scoresExample <- getScores(dataset1, geneSets = "tmod", method = "Z-score")

set.seed(123)
trainedModel <- trainModel(
    inputData = scoresExample,
    metadata = refData$metadata1,
    var2predict = "group",
    models = methodsML("svmLinear",
        outcomeClass = "character"
    ),
    Koutter = 2,
    Kinner = 2,
    repeatsCV = 1
)

externalScores <- getScores(dataset2, geneSets = "tmod", method = "Z-score")
realValues <- refData$metadata2$group
names(realValues) <- rownames(refData$metadata2)
predictions <- predictExternal(externalScores, trainedModel,
    realValues = realValues
)

print(predictions)

}
\references{
Toro-Domínguez, D. et al (2022). \emph{Scoring personalized
molecular portraits identify Systemic Lupus Erythematosus subtypes and
predict individualized drug responses, symptomatology and
disease progression}
 . Briefings in Bioinformatics. 23(5)
}
\author{
Iván Ellson, \email{ivan.ellson.l@gmail.com }

Jordi Martorell-Marugán, \email{jordi.martorell@genyo.es}

Daniel Toro-Dominguez, \email{danieltorodominguez@gmail.com}
}
