% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildRefObject.R
\name{buildRefObject}
\alias{buildRefObject}
\title{Create a reference data object for input to the pathMED functions}
\usage{
buildRefObject(data, metadata = NULL, groupVar, controlGroup, use.assay = 1)
}
\arguments{
\item{data}{A list of matrices, data frames, ExpressionSets or
SummarizedExperiments with samples in columns and features in rows. A single
matrix, dataframe, ExpressionSet or SummarizedExperiment may be also used.}

\item{metadata}{A list of data frames or a single data frame with information
for each sample. Samples in rows and variables in columns. If a list of
ExpressionSets or SummarizedExperiments are used as @data, it is not
necessary to provide @metadata.}

\item{groupVar}{Character or list of characters indicating the column name of
@metadata classifying the samples in controls and cases. If several metadata
objects are provided a @groupVar can be specified for each metadata.}

\item{controlGroup}{Character or list of characters indicating which
@groupVar level corresponds to the control group, usually healthy samples.
All other samples will be considered as cases, usually disease samples. If
several @groupVar are provided a @controlGroup can be specified
for each @groupVar}

\item{use.assay}{If SummarizedExperiments are used, the number of the assay 
to extract the data.}
}
\value{
A refObject that serves as input
 for mScores_createReference and dissectDB functions.
}
\description{
Create a reference data object for input to the pathMED functions
}
\examples{
data(refData)

refObject <- buildRefObject(
    data = list(
        refData$dataset1, refData$dataset2,
        refData$dataset3, refData$dataset4
    ),
    metadata = list(
        refData$metadata1, refData$metadata2,
        refData$metadata3, refData$metadata4
    ),
    groupVar = "group",
    controlGroup = "Healthy_sample"
)

## Also works with a metadata for all datasets
metadata <- rbind(
    refData$metadata1, refData$metadata2,
    refData$metadata3, refData$metadata4
)
refObject <- buildRefObject(
    data = list(
        refData$dataset1, refData$dataset2,
        refData$dataset3, refData$dataset4
    ),
    metadata = metadata,
    groupVar = "group",
    controlGroup = "Healthy_sample"
)

}
\references{
Toro-Domínguez, D. et al (2022). \emph{Scoring personalized
molecular portraits identify Systemic Lupus Erythematosus subtypes and
predict individualized drug responses, symptomatology and
disease progression}
 . Briefings in Bioinformatics. 23(5)
}
\seealso{
\code{\link{mScores_createReference}}, \code{\link{dissectDB}}
}
\author{
Iván Ellson, \email{ivan.ellson@gmail.com }

Jordi Martorell-Marugán, \email{jordi.martorell@genyo.es}

Daniel Toro-Dominguez, \email{danieltorodominguez@gmail.com}
}
