% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ann2term.R
\name{ann2term}
\alias{ann2term}
\title{Annotate the pathways from a scores matrix}
\usage{
ann2term(scoresMatrix)
}
\arguments{
\item{scoresMatrix}{Matrix with pathways IDs as row names}
}
\value{
A data frame with the input IDs and their corresponding terms
}
\description{
Annotate the pathways from a scores matrix
}
\examples{
data(pathMEDExampleData)
scoresExample <- getScores(pathMEDExampleData, geneSets = "tmod", 
                             method = "GSVA")
annotatedTerms <- ann2term(scoresExample)
}
\references{
Toro-Domínguez, D. et al (2022). \emph{Scoring personalized
molecular portraits identify Systemic Lupus Erythematosus subtypes and
predict individualized drug responses, symptomatology and
disease progression}
 . Briefings in Bioinformatics. 23(5)
}
\seealso{
\code{\link{getScores}}
}
\author{
Raúl López-Domínguez, \email{raul.lopez@genyo.es}

Jordi Martorell-Marugán, \email{jordi.martorell@genyo.es}

Daniel Toro-Dominguez, \email{danieltorodominguez@gmail.com}
}
