% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNetworks.R
\name{plotNetworks}
\alias{plotNetworks}
\title{Plot networks created by GatherNetworks function}
\usage{
plotNetworks(networks, pathway = "all", ...)
}
\arguments{
\item{networks}{networks object obtained
with \code{\link[pairkat]{GatherNetworks}}}

\item{pathway}{Pathway to be plotted. Leaving this as
'all' will plot all pathways in `networks`}

\item{...}{Parameters to be passed to the \code{\link[base]{plot}}
(i.e. \code{\link[igraph]{plot.igraph}}) function}
}
\value{
a plot or list of plots generated by igraph
}
\description{
Helper function for plotting networks of metabolites gathered
from the KEGG pathways database using the 
\code{\link[pairkat]{GatherNetworks}} function.
}
\details{
Plots the specified network(s) as an \code{\link[igraph]{igraph}}
}
\examples{
data(smokers)

# Query KEGGREST API
networks <- GatherNetworks(SE = smokers, keggID = "kegg_id",
species = "hsa", minPathwaySize = 5)

# Plot all networks
plotNetworks(networks)

# Plot specific network
plotNetworks(networks,
pathway = "Glycerophospholipid metabolism",
layout = igraph::layout_with_kk,
main = "Glycerophospholipid Metabolism")

}
