% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_image_bg.R
\name{remove_image_bg}
\alias{remove_image_bg}
\title{Remove image background}
\source{
\code{
path <- paste0("https://images.phylopic.org/images/",
"2de1c95c-7e1f-429b-9c08-17f0a27d176f/vector.svg")
img_res <- remove_image_bg(path=path)
}
}
\usage{
remove_image_bg(
  path,
  color = "white",
  fuzz = 0,
  save_path = file.path(tempdir(), "phylopic_processed", paste0(basename(dirname(path)),
    ".png"))
)
}
\arguments{
\item{path}{a file, url, or raster object or bitmap array}

\item{color}{a valid \href{https://imagemagick.org/Magick++/Color.html}{color string} such as
\code{"navyblue"} or \code{"#000080"}. Use \code{"none"} for transparency.}

\item{fuzz}{relative color distance (value between 0 and 100) to be considered similar
in the filling algorithm}
}
\value{
Named list containing the modified image itself and 
the saved path of the modified image.
}
\description{
Import and image and remove the background using \pkg{magick}.
}
\keyword{internal}
