% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_rows_monocle3.R
\name{aggregate_rows_monocle3}
\alias{aggregate_rows_monocle3}
\title{Aggregate rows: monocle3}
\source{
\code{ 
x <- Matrix::rsparsematrix(nrow = 1000, ncol = 2000, density = .10)
groupings <- rep(c("A","B"),nrow(x)/2)
X2 <- orthogene:::aggregate_rows_monocle3(x = x, groupings=groupings)
}
}
\usage{
aggregate_rows_monocle3(
  x,
  groupings = NULL,
  form = NULL,
  fun = "sum",
  na.action = stats::na.omit
)
}
\arguments{
\item{x}{Input matrix.}

\item{groupings}{Gene groups of the same length as \code{nrow(X)}.}

\item{form}{Formula.}

\item{fun}{Aggregation function.}

\item{na.action}{Na action.}
}
\value{
Aggregated matrix.
}
\description{
Aggregate rows: monocle3
}
\keyword{internal}
