% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimization_algo.R
\name{plot.all.cvg.info}
\alias{plot.all.cvg.info}
\title{Plots Coverage Information}
\usage{
\method{plot}{all.cvg.info}(
  sample,
  results.loc,
  primers,
  template.df,
  mode.directionality,
  identifier = c("filtering", "optimized"),
  primer_conc,
  na_salt_conc,
  mg_salt_conc,
  k_salt_conc,
  tris_salt_conc,
  settings,
  required.cvg,
  used.settings = NULL
)
}
\arguments{
\item{sample}{Primer design run identifier.}

\item{results.loc}{Location where the filtering results are stored.}

\item{primers}{Primer data frame.}

\item{template.df}{Template data frame.}

\item{mode.directionality}{Design direction.}

\item{identifier}{Identifies whether filtering or optimization info should be displayed.}

\item{primer_conc}{Primer concentration.}

\item{na_salt_conc}{Sodium ion concentration.}

\item{mg_salt_conc}{Magensium ion concentration.}

\item{k_salt_conc}{Potassium ion concentration.}

\item{tris_salt_conc}{Tris ion concentration.}

\item{settings}{The \code{DesignSettings} object.}

\item{required.cvg}{The required coverage.}

\item{used.settings}{A list containing \code{DesignSettings} objects for the 'fw' and 'rev' optimization.}
}
\value{
Writes plots to files.
}
\description{
Visualizes all coverage-related data.
}
\keyword{internal}
