% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_annealing_temperature.R
\name{compute_annealing_temp}
\alias{compute_annealing_temp}
\title{Annealing temperature.}
\usage{
compute_annealing_temp(
  primer.df,
  mode.directionality,
  template.df,
  na_salt_conc,
  mg_salt_conc,
  k_salt_conc,
  tris_salt_conc,
  primer_conc
)
}
\arguments{
\item{primer.df}{Primer data frame.}

\item{mode.directionality}{Primer directionality.}

\item{template.df}{Template data frame}

\item{na_salt_conc}{Sodium ion concentration.}

\item{mg_salt_conc}{Magensium ion concentration.}

\item{k_salt_conc}{Potassium ion concentration.}

\item{tris_salt_conc}{Tris buffer concentration.}

\item{primer_conc}{Primer concentration.}
}
\value{
The optimal annealing temperature.
}
\description{
Identifies the optimal annealing temperature of a set of primers.
If primers cover template sequences, the annealing temperature
is computed using Rychlik's formula.
Otherwise, the annealing temperature is determined using the
rule of thumb based on the melting temperatures of the primers.
}
\keyword{internal}
