% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/templates.R, R/primers.R, R/Plots.R,
%   R/plots_constraints.R, R/plots_coverage.R
\name{Plots}
\alias{Plots}
\alias{plot_conservation}
\alias{plot_primer_binding_regions}
\alias{plot_constraint}
\alias{plot_constraint_fulfillment}
\alias{plot_cvg_constraints}
\alias{plot_constraint_deviation}
\alias{plot_cvg_vs_set_size}
\alias{plot_penalty_vs_set_size}
\alias{plot_primer_subsets}
\alias{plot_primer}
\alias{plot_template_cvg}
\alias{plot_primer_cvg}
\title{Plotting Functions.}
\usage{
plot_conservation(entropy.df, alignments, template.df, gap.char = "-")

plot_primer_binding_regions(
  primers,
  templates,
  direction = c("both", "fw", "rev"),
  group = NULL,
  relation = c("fw", "rev"),
  region.names = c("Binding region", "Amplification region"),
  ...
)

plot_constraint(
  primers,
  settings,
  active.constraints = names(constraints(settings)),
  ...
)

plot_constraint_fulfillment(
  primers,
  settings,
  active.constraints = names(constraints(settings)),
  plot.p.vals = FALSE,
  ...
)

plot_cvg_constraints(
  primers,
  settings,
  active.constraints = names(cvg_constraints(settings)),
  ...
)

plot_constraint_deviation(
  primers,
  settings,
  active.constraints = names(constraints(settings)),
  ...
)

plot_cvg_vs_set_size(
  primer.data,
  template.data,
  show.labels = TRUE,
  highlight.set = NULL
)

plot_penalty_vs_set_size(
  primer.data,
  settings,
  active.constraints = names(constraints(settings)),
  alpha = 0
)

plot_primer_subsets(primer.subsets, template.df, required.cvg = 1)

plot_primer(
  primer.df,
  template.df,
  identifier = NULL,
  relation = c("fw", "rev"),
  region.names = c("Binding region", "Amplification region")
)

plot_template_cvg(primers, templates, per.mismatch = FALSE, ...)

plot_primer_cvg(primers, templates, per.mismatch = FALSE, ...)
}
\arguments{
\item{entropy.df}{A data frame with entropies.
Each row gives the entropies of a group of related template
sequences for all columns of the alignment.}

\item{alignments}{A list with \code{DNABin} alignment objects
corresponding to the groups (rows) in the alignment.}

\item{template.df}{An object of class \code{Templates} containing the
template sequences.}

\item{gap.char}{The gap char in the alignments. By default,
\code{gap.char} is set to "-".}

\item{primers}{Either a single \code{Primers} object with evaluated primer coverage
or a list containing such \code{Primers} objects.}

\item{templates}{If \code{primers} is a \code{Primers} object, \code{templates} should be a \code{Templates} object.
If \code{primers} is a list, then \code{templates} should be a list of \code{Templates} objects.}

\item{direction}{The directionality of primers to be plotted. This can either
be "both" to plot primers of both directions (the default), "fw" to plot
only forward primers, or "rev" to plot only reverse primers.}

\item{group}{Optional identifiers of template groups for which binding events should
be determined. By default, \code{group} is set to \code{NULL} such that
all templates are considered.}

\item{relation}{Whether binding positions are computed relative to forward ("fw")
or reverse ("rev") binding regions. The default is "fw".}

\item{region.names}{Character vector of length 2 providing the names
of the binding and amplification region.}

\item{...}{Optional arguments \code{groups} (a character vector of groups to be plotted when \code{primers} is a single primer set), 
\code{highlight.set} (the identifier of a primer set to be highlighted when \code{primers} is a list), 
\code{ncol} (a numeric indicating the number of facet columns if \code{primers} is a list),
\code{deviation.per.primer} (a boolean indicating whether constraint deviations
should be plotted per primer rather than per constraint if \code{primers} is a list)}

\item{settings}{An object of class \code{DesignSettings} containing
the constraints to be considered.}

\item{active.constraints}{A character vector containing the identifiers
to be considered for plotting. By default, \code{active.constraints} is
\code{NULL} such that all computed constraints found in \code{settings} are plotted.}

\item{plot.p.vals}{An optional logical argument indicating whether
p-values computed via \code{\link{primer_significance}} should be annotated in the plot. The default is \code{FALSE}.}

\item{primer.data}{List with objects of class \code{Primers} containing
the primer sets that are to be compared.}

\item{template.data}{List with objects of class \code{Templates} containing
the templates corresponding to \code{primer.data}.}

\item{show.labels}{Whether the identifiers of the primer sets
should be annotated in the plot. The default is \code{TRUE}.}

\item{highlight.set}{A character vector providing the identifiers
of primer sets to highlight. By default, \code{highlight.set} is \code{NULL}
such that no highlighting takes place.}

\item{alpha}{A numeric in the range [0,1] defining the trade-off between
the maximal deviation of a constraint (large \code{alpha}) and
all constraint deviations (large \code{alpha}).
By default, \code{alpha} is set to 0 such that the absolute
deviation across all constraints is considered.}

\item{primer.subsets}{A list with optimal primer subsets, each of class \code{Primers}. The \code{k}-th list entry should correspond to an object of class \code{Primers}
representing the primer subset of size \code{k} whose coverage ratio
is the largest among all possible subsets of size \code{k}.}

\item{required.cvg}{The required coverage ratio.
The default is 100\%; this value is plotted as a horizontal line.}

\item{primer.df}{An object of class \code{Primers} containing
primers with evaluated primer coverage.}

\item{identifier}{Identifiers of primers that are to be considered.
If \code{identifier} is set to \code{NULL} (the default), all primers are considered.}

\item{per.mismatch}{A logical specifying whether the visualization should be stratified
according to the allowed number of mismatches. By default,
\code{per.mismatch} is set to \code{FALSE} such that the overall coverage
is plotted.}
}
\value{
\code{plot_conseration} returns a plot showing the degree of sequence conservation in the templates.

\code{plot_primer_binding_regions} returns a plot of the primer binding regions.

\code{plot_constraint} returns a plot showing the distribution of primer properties.

\code{plot_constraint_fulfillment} returns a plot indicating the constraints that are fulfilled by the input primers.

\code{plot_cvg_constraints} returns a plot showing the distribution of the coverage constraint values.

\code{plot_constraint_deviation} returns a plot showing the deviations of the primer properties from the target constraints.

\code{plot_cvg_vs_set_size} returns a plot of coverage vs set size.

\code{plot_penalty_vs_set_size} returns a plot of constraint penalties
vs primer set sizes.

\code{plot_primer_subsets} plots the coverages of the primer subsets provided via \code{primer.subsets}.

\code{plot_primer} plots the primer binding sites in the templates.

\code{plot_template_cvg} creates a plot showing the number of covered template sequences.

\code{plot_primer_cvg} creates a plot showing the coverage of individual primers.
}
\description{
\describe{
\item{\code{plot_cvg_vs_set_size}}{Plots the coverage ratios of the input primer sets 
against the size of the sets.}
\item{\code{plot_penalty_vs_set_size}}{Plots the penalties of the input primer sets 
against the number of primers contained in each set.
The penalties are computed using \code{\link{score_primers}}
where more information is provided on how to set \code{alpha}.}
\item{\code{plot_primer_subsets}}{Visualizes the coverage of optimized primer subsets.}
\item{\code{plot_primer}}{Visualizes the binding positions of every primer relative to
the target binding region in the corresponding template sequences.}
\item{\code{plot_template_cvg}}{Creates a bar plot visualizing the covered templates.}
\item{\code{plot_primer_cvg}}{Shows which groups of templates are covered by individual primers.}
\item{\code{plot_constraint}}{Shows the distribution of the primer properties.
The current constraint settings are indicated with dashed lines.}
\item{\code{plot_constraint_fulfillment}}{Visualizes which primers pass the constraints 
and which primers break the constraints}
\item{\code{plot_cvg_constraints}}{Plots the distribution of the coverage constraint values.}
\item{\code{plot_constraint_deviation}}{Plots the deviation of primer properties from the target ranges.}
\item{\code{plot_primer_binding_regions}}{Visualizes the number of binding events of the primers
with respect to the allowed binding regions in the templates.}
\item{\code{plot_conservation}}{Plots the template sequence conservation (range [0,1]) according to
the Shannon entropy of the sequences.}
}
}
\details{
The deviations for \code{plot_constraint_deviation} are computed in the following way. Let the
minimum and maximum allowed constraint values be given by
the interval \eqn{[s, e]} and the observed value be \eqn{p}. Then,
if \eqn{p < s}, we output \eqn{-p/|s|}, if \eqn{p > e} we output \eqn{p/|e|},
and otherwise, i.e. if \eqn{s <= p <= e}, we output 0.

The \code{primer.subsets} argument for \code{plot_primer_subsets} can be computed using
\code{\link{subset_primer_set}}. 
The line plot indicates the ratio of covered templates when considering
all primers in a primer set of a given size. The bar plots indicate
the coverage ratios of individual primers in a set. The target coverage
ratio is indicated by a horizontal line. Bars exceeding the target ratio
possibly indicate the existence of redundant coverage events.
}
\note{
Computing the conservation scores for using \code{plot_conservation} requires
the MAFFT software for multiple alignments (http://mafft.cbrc.jp/alignment/software/).
}
\examples{

data(Ippolito)
# Select binding regions for every group of templates and plot:
template.df <- select_regions_by_conservation(template.df, win.len = 30)
if (length(template.df) != 0) {
     p1 <- plot_conservation(attr(template.df, "entropies"), 
                             attr(template.df, "alignments"), template.df)
}
# Select binding regions for all templates and plot:
data(Ippolito)
template.df <- select_regions_by_conservation(template.df, by.group = FALSE)
if (length(template.df) != 0) {
     p2 <- plot_conservation(attr(template.df, "entropies"), 
                             attr(template.df, "alignments"), template.df)
} 

# Primer binding regions of a single primer set
data(Ippolito)
p <- plot_primer_binding_regions(primer.df, template.df)
# Primer binding regions of multiple primer sets
data(Comparison)
p.comp <- plot_primer_binding_regions(primer.data[1:3], template.data[1:3])

# Plot histogram of constraints for a single primer set
data(Ippolito)
p <- plot_constraint(primer.df, settings, 
                     active.constraints = c("gc_clamp", "gc_ratio"))
# Compare constraints across multiple primer sets
data(Comparison)
p.cmp <- plot_constraint(primer.data[1:3], settings, 
                         active.constraints = c("gc_clamp", "gc_ratio"))

# Plot fulfillment for a single primer set:
data(Ippolito)
p <- plot_constraint_fulfillment(primer.df, settings)
# Plot fulfillment for multiple primer sets:
data(Comparison)
p.cmp <- plot_constraint_fulfillment(primer.data[1:5], settings)

# Plot coverage constraints of a single primer set
data(Ippolito)
p <- plot_cvg_constraints(primer.df, settings)
# Plot coverage constraints for mulitple primer sets
data(Comparison)
p.cmp <- plot_cvg_constraints(primer.data[1:2], settings)

# Deviations for a single primer set
data(Ippolito)
p.dev <- plot_constraint_deviation(primer.df, settings)
# Deviations for multiple primer sets
data(Comparison)
p.dev.cmp <- plot_constraint_deviation(primer.data, settings)

# Plot coverage vs primer set size
data(Comparison)
p <- plot_cvg_vs_set_size(primer.data, template.data)

# Plot penalties vs number of primers
data(Comparison)
p <- plot_penalty_vs_set_size(primer.data, settings)

# Plot the coverage of optimal primer subsets
data(Ippolito)
primer.subsets <- subset_primer_set(primer.df, template.df, k = 3)
p <- plot_primer_subsets(primer.subsets, template.df)

# Plot of individual primer binding positions
data(Ippolito)
p <- plot_primer(primer.df[1,], template.df[1:30,])

# Visualize the template coverage of a single primer set
data(Ippolito)
p.cvg <- plot_template_cvg(primer.df, template.df)
# Stratify by allowed mismatches:
p.mm.cvg <- plot_template_cvg(primer.df, template.df, per.mismatch = TRUE)
# Compare the coverage of multiple primer sets
data(Comparison)
p.cmp.cvg <- plot_template_cvg(primer.data[1:2], template.data[1:2])
# Stratify by allowed mismatches:
p.cmp.cvg.mm <- plot_template_cvg(primer.data[1:2], template.data[1:2], 
                                 per.mismatch = TRUE)

# Plot expected coverage per primer
data(Ippolito)
p.cvg <- plot_primer_cvg(primer.df, template.df)
# Plot coverage stratified by allowed mismatches:
p.cvg.mm <- plot_primer_cvg(primer.df, template.df, per.mismatch = TRUE)
# Plot coverage of multiple primer sets
data(Comparison)
p.cvg.cmp <- plot_primer_cvg(primer.data[1:3], template.data[1:3])
}
\concept{templates}
