% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Comparison.R, R/Data.R, R/Ippolito.R,
%   R/RefCoverage.R, R/Tiller.R
\docType{data}
\name{Data}
\alias{Data}
\alias{primer.data}
\alias{template.data}
\alias{template.df}
\alias{primer.df}
\alias{settings}
\alias{RefCoverage}
\alias{feature.matrix}
\alias{ref.data}
\alias{Tiller}
\alias{tiller.template.df}
\alias{tiller.primer.df}
\alias{tiller.settings}
\title{Data Sets.}
\format{
For the \code{RefCoverage} data set, the \code{feature.matrix} data frame contains the properties
of the primer set from Tiller et al. as well as a primer set
that was designed by openPrimeR. The column \code{Experimental_Coverage}
indicates the experimentally determined coverage, while the other
columns relate to properties of the primers that were computed
with openPrimeR. 
The \code{ref.data} list contains the raw experimental coverage
of individual primers from the primer sets from Tiller and openPrimeR, which
both target templates from the IGH locus.
The rows of the data frames indicate primers and the columns indicate
IGH templates for which experimental coverage was determined.
The cell entries are hex codes. Each hex code represents a color 
indicating a certain experimental coverage status. 
Hex codes representing red shades indicate no or little amplification, 
while hex codes for green shades indicate high yields.

For the \code{Ippolito} data set, 
\code{primer.df} provides a \code{Primers} object containing
the evaluated set of primers from Tiller et al.
\code{template.df} provides
a \code{Templates} object containing functional, human IGHV
templates for, and \code{settings} provides a 
\code{DesignSettings} object providing the used analysis settings.

For the \code{Comparison} data set, \code{primer.data} and \code{template.data} are
lists of \code{Primers} and \code{Templates} objects, respectively.

For the \code{Tiller} data set, \code{tiller.primer.df} 
provides a \code{Primers} object, \code{tiller.template.df} provides 
the corresponding \code{Templates} object, and \code{tiller.settings} 
provides the \code{DesignSettings} object that was used
for evaluating \code{tiller.primer.df}.
}
\usage{
data(Comparison)

data(Ippolito)

data(RefCoverage)

data(Tiller)
}
\description{
\describe{
\item{\code{Ippolito}}{IGHV primer data from Ippolito et al.}
\item{\code{Tiller}}{IGHV primer data from Tiller et al.}
\item{\code{Comparison}}{Evaluated primer sets targeting the 
functional human IGH immunoglobulin
genes. The sets were generated using the default evaluation settings
of openPrimeR. The primer sets were gathered from
IMGT and the literature.}
\item{\code{RefCoverage}}{Experimental results of multiplex PCR.}
}
}
\examples{

# Load the comparison data
data(Comparison)
# Explore the first entry of the primer and template data:
primer.data[[1]]
template.data[[1]]
# Summarize the primer properties:
get_comparison_table(template.data, primer.data)

# Load the data from Ippolito et al.
data(Ippolito)
primer.df
template.df
constraints(settings)

# Load experimental PCR results
data(RefCoverage)

# Load the data from Tiller et al.
data(Tiller)
tiller.primer.df
tiller.template.df
constraints(tiller.settings)
}
\references{
IMGT®, the international ImMunoGeneTics information system® http://www.imgt.org (founder and director: Marie-Paule Lefranc, Montpellier, France).

Ippolito GC, Hoi KH, Reddy ST, Carroll SM, Ge X, Rogosch T, 
Zemlin M, Shultz LD, Ellington AD, VanDenBerg CL, Georgiou G. 2012. 
Antibody Repertoires in Humanized NOD-scid-IL2R gamma null Mice and Human B
Cells Reveals Human-Like Diversification and Tolerance Checkpoints 
in the Mouse. PLoS One 7:e35497.

Tiller, Thomas, et al. "Efficient generation of monoclonal antibodies from single human B cells by single cell RT-PCR and expression vector cloning." Journal of immunological methods 329.1 (2008): 112-124.
}
\keyword{datasets}
