% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gatingTemplate-methods.R
\name{plot,gatingTemplate,missing-method}
\alias{plot,gatingTemplate,missing-method}
\alias{plot,gatingTemplate,character-method}
\alias{plot,gatingTemplate-method}
\alias{plot,gatingTemplate,ANY-method}
\title{plot the gating scheme}
\usage{
\S4method{plot}{gatingTemplate,missing}(x, y, ...)
}
\arguments{
\item{x}{\code{gatingTemplate} object}

\item{y}{either \code{character} specifying the root node which can be used to visualize only the subgraph 
or \code{missing} which display the entire gating scheme}

\item{...}{other arguments 

    graphAttr, nodeAttr:  graph rendering attributes passed to \link[Rgraphviz:renderGraph]{renderGraph}
    showRef \code{logical}: whether to display the reference gates. Sometime it maybe helpful to 
                            hide all those reference gates which are not the cell population of interest 
                            and used primarily for generating other population nodes.}
}
\description{
plot the gating scheme using Rgraphviz
}
\examples{
\dontrun{
gt <- gatingTemplate(system.file("extdata/gating_template/tcell.csv",package = "openCyto"))
plot(gt) #plot entire tree
plot(gt, "lymph") #only plot the subtree rooted from "lymph"
}
}
