% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_pop.R
\name{gs_add_gating_method_init}
\alias{gs_add_gating_method_init}
\alias{add_pop_init}
\title{Clear history of \code{gs_add_gating_method} calls for a given \code{GatingSet} or \code{GatingSetList}}
\usage{
gs_add_gating_method_init(gs)
}
\arguments{
\item{gs}{a \code{GatingSet} or \code{GatingSetList}. Can be omitted to clean entire \code{gs_add_gating_method} history.}
}
\description{
Repeated calls to the \code{\link{load_gs}} method in the same session
will yield indistinguishable objects that can result in overlapping history
of \code{\link{gs_add_gating_method}} calls. This method allows for the history to be cleared
if the user would like to reload the \code{GatingSet} and start fresh. Calling
\code{gs_add_gating_method_init} without an argument will clear the entire \code{gs_add_gating_method} history.
}
\examples{
\dontrun{
# load in a GatingSet
gs <- load_gs(path)
# Add some nodes using gs_add_gating_method
gs_add_gating_method(gs, gating_method = "mindensity", dims = "CCR7,CD45RA", parent = "cd4-cd8+", pop = "CCR7+/-CD45RA+/-")
gs_add_gating_method(gs, gating_method = "polyFunctions", parent = "cd8", gating_args = "cd8/IFNg:cd8/IL2:cd8/TNFa")
# Remove the effect of the last gs_add_gating_method call using gs_remove_gating_method (note that the first call's effects remain)
gs_remove_gating_method(gs)
# Re-load the GatingSet to start over
gs <- load_gs(path)

# At this point, gs will still see the history of the first gs_add_gating_method call above
# which will cause problems for later calls to gs_remove_gating_method.
# To fix that, just call gs_add_gating_method_init() to start a clean history
gs_add_gating_method_init(gs)
# Now you can continue using gs_add_gating_method and gs_remove_gating_method from scratch
gs_add_gating_method(gs, gating_method = "mindensity", dims = "CCR7,CD45RA", parent = "cd4-cd8+", pop = "CCR7+/-CD45RA+/-")
}

}
