% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oncoMix_two_component_mixture_models.R
\name{plotGeneHist}
\alias{plotGeneHist}
\title{Plot a histogram of gene expression values from
tumor and adjacent normal tissue.}
\usage{
plotGeneHist(mmParams, exprNml, exprTum, isof)
}
\arguments{
\item{mmParams}{The output from the getMixModelParams function.}

\item{exprNml}{A dataframe (S3 or S4), matrix, or SummarizedExperiment object
containing normal data with patients as columns and genes as rows.}

\item{exprTum}{A dataframe (S3 or S4), matrix, or SummarizedExperiment object
containing tumor data with patients as columns and genes as rows.}

\item{isof}{The gene isoform to visualize}
}
\value{
Returns a histogram of the gene expression
values from the two groups.
}
\description{
This function allows you to plot a histogram of gene expression values from
tumor and adjacent normal tissue with the option of including the best
fitting Gaussian curve.
}
\examples{
exprNml <- as.data.frame(matrix(data=rgamma(n=150, shape=2, rate=2),
nrow=10, ncol=15))
colnames(exprNml) <- paste0("patientN", seq_len(ncol(exprNml)))
rownames(exprNml) <- paste0("gene", seq_len(nrow(exprNml)))

exprTum <- as.data.frame(matrix(data=rgamma(n=150, shape=4, rate=3),
nrow=10, ncol=15))
colnames(exprTum) <- paste0("patientT", seq_len(ncol(exprTum)))
rownames(exprTum) <- paste0("gene", seq_len(nrow(exprTum)))
mmParams <- mixModelParams(exprNml, exprTum)
isof <- rownames(mmParams)[1]
plotGeneHist(mmParams, exprNml, exprTum, isof)
}
\seealso{
\code{\link{mixModelParams}}
}
\keyword{Gaussian,}
\keyword{oncoMix,}
\keyword{two-component}
\keyword{visualization,}
