% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proc_funs.R
\name{read_gmt}
\alias{read_gmt}
\title{Reading gene set .gmt file}
\usage{
read_gmt(x, id = NA, data.frame = FALSE)
}
\arguments{
\item{x}{the name/path of the gmt file to be read}

\item{id}{the id used in gene sets, if is not NA, it should be either "SYMBOL" 
or "ENTREZ". Usually only used when reading the .gmt file downloaded from 
MSigDB.}

\item{data.frame}{logical; whether to organize the data in \code{data.frame}
format. Default is FALSE, a list will be returned.}
}
\value{
a list or data frame of gene set. When data.frame = TRUE, the returned
  object is a \code{data.frame} with two columns: id and term.
}
\description{
Frequently the .gmt files are downloaed from MSigDB database
}
\examples{
file <- system.file("extdata", package = "omicsViewer")
file <- file.path(file, "geneset.gmt")
gs <- read_gmt(file)
}
