% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proc_funs.R
\name{normalizeData}
\alias{normalizeData}
\title{Normalized expression matrix}
\usage{
normalizeData(
  x,
  colWise = c("None", "Median centering", "Median centering (shared ID)", "Total sum",
    "median centering + variance stablization")[1],
  rowWise = c("None", "Reference", "Batch mean", "Batch reference")[1],
  ref = NULL,
  batch = NULL
)
}
\arguments{
\item{x}{an expression matrix where rows are features and columns are samples, usually log transformed.}

\item{colWise}{column-wise normalization method to use, see \code{\link{normalizeColWise}}}

\item{rowWise}{row-wise normalization method to used{}
\code{Reference} - using \code{\link{removeVarQC}} method
\code{Batch mean} - using \code{\link{rowshift}} method without reference samples
\code{Batch reference} - using \code{\link{rowshift}} method with reference samples}

\item{ref}{index of reference samples}

\item{batch}{batch factor}
}
\value{
a normalized matrix
}
\description{
A wrapper function of all normalization methods, including row-wise or column-wise normalization.
}
\examples{
e1 <- matrix(rnorm(5000), 100, 50)+10
boxplot(e1)
e2 <- normalizeData(x = e1, ref = seq(5, 45, by = 10), rowWise = "Reference")
boxplot(e2)

}
