% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_AllMethods.R, R/ResultSet-plotAssociation.R
\docType{methods}
\name{plotAssociation}
\alias{plotAssociation}
\alias{plotAssociation,ResultSet-method}
\alias{plotAssociation}
\title{Function to draw de result of an association study}
\usage{
plotAssociation(object, rid = 1, coef = 2, contrast = 1,
  type = c("manhattan", "qq", "volcano"), tPV = NULL, tFC = NULL,
  show.effect = FALSE)

\S4method{plotAssociation}{ResultSet}(object, rid = 1, coef = 2,
  contrast = NULL, type = c("manhattan", "qq", "volcano"), tPV = NULL,
  tFC = NULL, show.effect = FALSE)
}
\arguments{
\item{object}{An object of class \link{ResultSet} obtained from assoc_*
functions.}

\item{rid}{(default \code{1}) Index or name of the test to be plotted.}

\item{coef}{(default \code{2}) Index of the coefficient to be extracted.}

\item{contrast}{(default \code{1}) When \code{code} corresponds to a
multicategorical variable, contasr selects the comparison.}

\item{type}{Can take \code{"volcano"}, \code{"qq"},  \code{"manhattan"} and
\code{"protein"}. \code{"protein"} lot is a type of Manhattan plot designed
for protein association analysis.}

\item{tPV}{(optional) Threshold for P.Value when \code{type="volcano"}.}

\item{tFC}{(optional) Threshold for Fold Change or Effect when
\code{type="volcano"}.}

\item{show.effect}{(default \code{FALSE}) If set to \code{TRUE}, when
\code{type="volcano"} the X-axis will show \code{2^logFC} instead of
\code{logFC}.}
}
\value{
A ggplot2 object
}
\description{
This function draws two type of plots for the ResultSet from association
functions
}
\examples{
data("asr", package = "omicRexposome")
plotAssociation(asr, type = "qq")
plotAssociation(asr, type = "volcano")
}
\seealso{
\code{\link{plotIntegration}} for plotting integration results.
\code{\link{association}} to create a \code{ResultSet} to be passed to
this function.
}
