% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nucleoSimInternFunctions.R
\name{syntheticNucMapFromDistValidation}
\alias{syntheticNucMapFromDistValidation}
\title{Parameter validation for the \code{\link{syntheticNucMapFromDist}}
function}
\usage{
syntheticNucMapFromDistValidation(
  wp.num,
  wp.del,
  wp.var,
  fuz.num,
  fuz.var,
  max.cover,
  nuc.len,
  len.var,
  lin.len,
  rnd.seed,
  as.ratio
)
}
\arguments{
\item{wp.num}{a non-negative \code{integer}, the number of well-positioned
(non overlapping) nucleosomes.}

\item{wp.del}{a non-negative \code{integer}, the number of well-positioned
nucleosomes to remove to create uncovered regions.}

\item{wp.var}{a non-negative \code{integer}, the variance
of the starting position of the sequences associated with well-positioned
nucleosomes. This parameter introduces some variation in the starting
position of the sequences describing a nucleosome.}

\item{fuz.num}{a non-negative \code{integer}, the number of fuzzy
nucleosomes. Those nucleosomes can overlap other well-positioned or
fuzzy nucleosomes.}

\item{fuz.var}{a non-negative \code{integer}, the variance of the fuzzy
nucleosomes. This variance
can be different than the one used for the well-positioned
nucleosome reads.}

\item{max.cover}{a positive \code{integer}, the maximum coverage for one
nucleosome. The final coverage
can have a higher value than \code{max.cover} since reads from differents
nucleosomes can be overlapping.}

\item{nuc.len}{a non-negative \code{integer}, the nucleosome length.}

\item{len.var}{a non-negative \code{integer}, the variance of the
distance between a forward read and its paired reverse read.}

\item{lin.len}{a non-negative \code{integer}, the length of the DNA
linker DNA.}

\item{rnd.seed}{a single value, interpreted as an \code{integer}, or
\code{NULL}. If a \code{integer} is given, the value is used to set the seed
of the random number generator. By fixing the seed, the generated results
can be reproduced.}

\item{as.ratio}{a \code{logical}, if \code{TRUE},  a synthetic naked DNA
control map is created and the ratio between it and the nucleosome coverage
are calculated. It can be used to simulate hybridization ratio data, like
the one in Tiling Arrays. Both control map and calculated ratio are
returned.}
}
\value{
\code{0} indicating that all parameters validations have been
successful.
}
\description{
Validate that all values passed to the function are formated
for the \code{\link{syntheticNucMapFromDist}} function.
}
\examples{

## The function returns 0 when all paramaters are valid
nucleoSim:::syntheticNucMapFromDistValidation(wp.num = 20, wp.del = 2,
wp.var = 3, fuz.num = 10, fuz.var = 5, max.cover = 100, nuc.len = 147,
len.var = 4, lin.len = 40, rnd.seed = 201, as.ratio = FALSE)

## The function raises an error when at least one paramater is not valid
\dontrun{nucleoSim:::syntheticNucMapFromDistValidation(wp.num = -1,
wp.del = 2, wp.var = 3, fuz.num = 10, fuz.var = 5, max.cover = 100,
nuc.len = 147, len.var = 4, lin.len = 40, rnd.seed = 201, as.ratio = FALSE)}
\dontrun{nucleoSim:::syntheticNucMapFromDistValidation(wp.num = 20,
wp.del = 2, wp.var = -3, fuz.num = 10, fuz.var = 5, max.cover = 100,
nuc.len = 147, len.var = 4, lin.len = 40, rnd.seed = 201, as.ratio = FALSE)}

}
\author{
Astrid Deschenes
}
\keyword{internal}
