% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormRCountConfig.R
\docType{class}
\name{NormRCountConfig-class}
\alias{NormRCountConfig-class}
\alias{NormRCountConfig}
\alias{BamsignalsConfig}
\alias{BamsignalsCountConfig}
\alias{countConfigSingleEnd,ANY-method}
\alias{countConfigSingleEnd}
\alias{configSingleEnd}
\alias{countConfigPairedEnd,ANY-method}
\alias{countConfigPairedEnd}
\alias{configPairedEnd}
\alias{getFilter,NormRCountConfig-method}
\alias{getFilter}
\alias{getBamsignalsFilter}
\alias{getNormRCountConfigFilter}
\alias{print,NormRCountConfig-method}
\alias{show,NormRCountConfig-method}
\title{Container for configuration of read counting with bamsignals in normR}
\usage{
\S4method{countConfigSingleEnd}{ANY}(binsize = 250L, mapq = 20L,
  filteredFlag = 1024L, shift = 0L)

\S4method{countConfigPairedEnd}{ANY}(binsize = 250L, mapq = 20L,
  filteredFlag = 1024L, shift = 0L, midpoint = TRUE, tlenFilter = c(70L,
  200L))

\S4method{getFilter}{NormRCountConfig}(x)

\S4method{print}{NormRCountConfig}(x, ...)

\S4method{show}{NormRCountConfig}(object)
}
\arguments{
\item{binsize}{An \code{integer()} specifying the binsize in bp.}

\item{mapq}{An \code{integer()} specifying the minimal mapping quality for a
read to be counted.}

\item{filteredFlag}{An \code{integer()} to filter for in the SAMFLAG field.
For example, 1024 filters out marked duplicates (default). Refer to
\url{https://broadinstitute.github.io/picard/explain-flags.html} for
details.}

\item{shift}{An \code{integer()} specifing a shift of the read counting
position in 3'-direction. This can be handy in the analysis of chip-seq
data.}

\item{midpoint}{Paired End data only: A \code{logical()} indicating whether
fragment midpoints instead of 5'-ends should be counted.}

\item{tlenFilter}{An \code{integer()} of length two specifying the lower and
upper length bound for a fragment to be considered. The fragment length as
estimated from alignment in paired end experiments and written into the TLEN
column.}

\item{x}{A \code{NormRCountConfig} object.}

\item{...}{optional arguments to be passed directly to the inherited
function without alteration and with the original names preserved.}

\item{object}{A \code{NormRCountConfig} object.}
}
\value{
A \code{\link{NormRCountConfig}} with specified counting parameters
for \code{\link{normr}} methods (\code{\link{enrichR}}, \code{\link{diffR}},
\code{\link{regimeR}}
}
\description{
This S4 class is a small wrapper for a configuration on obtaining counts from
bamfiles with
\code{\link[bamsignals:bamsignals-methods]{bamsignals::bamProfile}()}. Herein,
two functions provide help for creating an instance of this class:
\code{\link{countConfigSingleEnd}} creates a configuration for single end reads;
and \code{\link{countConfigPairedEnd}} creates a configuration for paired end
reads.
}
\section{Methods (by generic)}{
\itemize{
\item \code{countConfigSingleEnd}: Setup single end count configuration

\item \code{countConfigPairedEnd}: Setup paired end count configuration

\item \code{getFilter}: Get the filter compliant to
\code{\link[bamsignals:bamsignals-methods]{bamsignals::bamProfile}()}

\item \code{print}: Prints a given BamCounConfig

\item \code{show}: Shows a given BamCounConfig
}}

\section{Slots}{

\describe{
\item{\code{type}}{A \code{character} of value \code{paired.end} or
\code{single.end}.}

\item{\code{binsize}}{An \code{integer} specifying the binsize in bp.}

\item{\code{mapq}}{An \code{integer} specifying the minimal mapping quality for a
read to be counted.}

\item{\code{filteredFlag}}{An \code{integer} to filter for in the SAMFLAG field.
For example, 1024 filters out marked duplicates (default). Refer to
\url{https://broadinstitute.github.io/picard/explain-flags.html} for
details.}

\item{\code{shift}}{An \code{integer} specifing a shift of the read counting
position in 3'-direction. This can be handy in the analysis of chip-seq
data.}

\item{\code{midpoint}}{Paired End data only: A \code{logical} indicating whether
fragment midpoints instead of 5'-ends should be counted.}

\item{\code{tlenFilter}}{Paired End data only: An \code{integer} of length two
specifying the lower and upper length bound for a fragment to be considered.
The fragment length as estimated from alignment in paired end experiments
and written into the TLEN column.}
}}

\examples{
### Create an instance of this class (see below for helper functions)
# 250bp bins; single end reads; MAPQ>=10; no duplicates
countConfig <- new("NormRCountConfig", 
                   type = "single.end", binsize = 250L, mapq = 10L, 
                   filteredFlag = 1024L, shift = 0L, midpoint = FALSE, 
                   tlenFilter = NULL)

### Counting configuration for Single End alignment files
# 250bp bins (default); only reads with MAPQ>=20; move counting position 100bp
countConfigurationSE <- countConfigSingleEnd(mapq = 20, shift = 100)
countConfigurationSE

### Counting configuration for Paired End alignment files
# 250bp bins; count center of fragments; only fragments with 70bp<=length<=200
countConfigurationPE <- countConfigPairedEnd(midpoint = TRUE,
                                             tlenFilter = c(70, 200))
countConfigurationPE
}
\seealso{
\link{normr} for functions that use this object.
}
\author{
Johannes Helmuth \email{helmuth@molgen.mpg.de}
}
