/** @file HierarchicalClustering_main.cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.6
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef HIERARCHICALCLUSTERING_MAIN_CMDLINE_H
#define HIERARCHICALCLUSTERING_MAIN_CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE "hierarchical_clustering (MC-UPGMA)"
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define CMDLINE_PARSER_PACKAGE_NAME "hierarchical_clustering (MC-UPGMA)"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION "2.0"
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  float max_distance_arg;	/**< @brief Max possible distance between two singletons (\\psi). Used for missing edges when averaging across clusters. .  */
  char * max_distance_orig;	/**< @brief Max possible distance between two singletons (\\psi). Used for missing edges when averaging across clusters.  original value given at command line.  */
  const char *max_distance_help; /**< @brief Max possible distance between two singletons (\\psi). Used for missing edges when averaging across clusters.  help description.  */
  int max_cluster_index_arg;	/**< @brief Index of the last singleton (may be more than that).  */
  char * max_cluster_index_orig;	/**< @brief Index of the last singleton (may be more than that) original value given at command line.  */
  const char *max_cluster_index_help; /**< @brief Index of the last singleton (may be more than that) help description.  */
  int number_of_input_edges_arg;	/**< @brief Memory constraint - maximum number of edges to load from input.  */
  char * number_of_input_edges_orig;	/**< @brief Memory constraint - maximum number of edges to load from input original value given at command line.  */
  const char *number_of_input_edges_help; /**< @brief Memory constraint - maximum number of edges to load from input help description.  */
  char * average_type_arg;	/**< @brief {arithmetic, geometric, minimum, maximum} - the clustering objective (e.g. average-linkage, complete-linkage etc.). (default='arithmetic').  */
  char * average_type_orig;	/**< @brief {arithmetic, geometric, minimum, maximum} - the clustering objective (e.g. average-linkage, complete-linkage etc.). original value given at command line.  */
  const char *average_type_help; /**< @brief {arithmetic, geometric, minimum, maximum} - the clustering objective (e.g. average-linkage, complete-linkage etc.). help description.  */
  char * input_cluster_edges_file_arg;	/**< @brief Cluster (or singleton) edges (format: cluster1 cluster2 distance) (default='-').  */
  char * input_cluster_edges_file_orig;	/**< @brief Cluster (or singleton) edges (format: cluster1 cluster2 distance) original value given at command line.  */
  const char *input_cluster_edges_file_help; /**< @brief Cluster (or singleton) edges (format: cluster1 cluster2 distance) help description.  */
  char * output_merges_file_name_arg;	/**< @brief Output merges file (default='-').  */
  char * output_merges_file_name_orig;	/**< @brief Output merges file original value given at command line.  */
  const char *output_merges_file_name_help; /**< @brief Output merges file help description.  */
  char * input_cluster_sizes_file_name_arg;	/**< @brief Initial size of each input cluster (singleton size).  */
  char * input_cluster_sizes_file_name_orig;	/**< @brief Initial size of each input cluster (singleton size) original value given at command line.  */
  const char *input_cluster_sizes_file_name_help; /**< @brief Initial size of each input cluster (singleton size) help description.  */
  char * output_cluster_sizes_file_name_arg;	/**< @brief End size of each output cluster (cluster size).  */
  char * output_cluster_sizes_file_name_orig;	/**< @brief End size of each output cluster (cluster size) original value given at command line.  */
  const char *output_cluster_sizes_file_name_help; /**< @brief End size of each output cluster (cluster size) help description.  */
  int allow_non_dendrogram_flag;	/**< @brief Allows merging of provably minimal edge intervals, even if the exact merge score (cluster height in dendrogram) is not known at merge time due to partial knowledge implied by the memory constraint. This option allows further clustering per round, thus speeding up the wholse clustering process considerably, by posing a less strict requirement on the output - now the cluster heights are no longer required to be exact. Currently, an upper bound on the merge score is output in this case. (default=off).  */
  const char *allow_non_dendrogram_help; /**< @brief Allows merging of provably minimal edge intervals, even if the exact merge score (cluster height in dendrogram) is not known at merge time due to partial knowledge implied by the memory constraint. This option allows further clustering per round, thus speeding up the wholse clustering process considerably, by posing a less strict requirement on the output - now the cluster heights are no longer required to be exact. Currently, an upper bound on the merge score is output in this case. help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int max_distance_given ;	/**< @brief Whether max-distance was given.  */
  unsigned int max_cluster_index_given ;	/**< @brief Whether max-cluster-index was given.  */
  unsigned int number_of_input_edges_given ;	/**< @brief Whether number-of-input-edges was given.  */
  unsigned int average_type_given ;	/**< @brief Whether average-type was given.  */
  unsigned int input_cluster_edges_file_given ;	/**< @brief Whether input-cluster-edges-file was given.  */
  unsigned int output_merges_file_name_given ;	/**< @brief Whether output-merges-file-name was given.  */
  unsigned int input_cluster_sizes_file_name_given ;	/**< @brief Whether input-cluster-sizes-file-name was given.  */
  unsigned int output_cluster_sizes_file_name_given ;	/**< @brief Whether output-cluster-sizes-file-name was given.  */
  unsigned int allow_non_dendrogram_given ;	/**< @brief Whether allow-non-dendrogram was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief the description string of the program */
extern const char *gengetopt_args_info_description;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* HIERARCHICALCLUSTERING_MAIN_CMDLINE_H */
