% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustClusters.R
\name{robustClusters,SummarizedExperiment-method}
\alias{robustClusters,SummarizedExperiment-method}
\alias{robustClusters}
\alias{robustClusters,matrix-method}
\title{Perform robust clustering on dataset, and calculate the proportion of
samples in robust clusters}
\usage{
\S4method{robustClusters}{SummarizedExperiment}(x, dimReduceFlavor = "auto", is.counts = TRUE, ...)

\S4method{robustClusters}{matrix}(x, ...)
}
\arguments{
\item{x}{matrix or SummarizedExperiment object}

\item{dimReduceFlavor}{algorithm for dimensionality reduction step
of clustering procedure. May be 'pca', 'tsne',
'dm', 'umap' or 'auto', which uses shannon entropy to
pick the algorithm.}

\item{is.counts}{logical: is the data counts}

\item{...}{arguments passed on to `clusterExperimentWorkflow`}
}
\value{
list(clusters, proportion.robust)
}
\description{
Perform robust clustering on dataset, and calculate the proportion of
samples in robust clusters
}
\examples{
data("smallscRNAseq")
robustClusters(smallscRNAseq, dimReduceFlavor='pca')
}
