% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pickDimReduction.R
\name{pickDimReduction,matrix-method}
\alias{pickDimReduction,matrix-method}
\alias{pickDimReduction}
\alias{pickDimReduction,SummarizedExperiment-method}
\alias{pickDimReduction,Matrix-method}
\alias{pickDimReduction,DelayedMatrix-method}
\title{Pick the dimensionality reduction method for a dataset that gives the
2D embedding with the highest entropy}
\usage{
\S4method{pickDimReduction}{matrix}(x, flavors = c("pca", "tsne", "umap"), is.counts = TRUE)

\S4method{pickDimReduction}{SummarizedExperiment}(x)

\S4method{pickDimReduction}{Matrix}(x, flavors = c("pca", "tsne", "umap"), is.counts = TRUE)

\S4method{pickDimReduction}{DelayedMatrix}(x, flavors = c("pca", "tsne", "umap"), is.counts = TRUE)
}
\arguments{
\item{x}{matrix or SummarizedExperiment object [GENES x SAMPLES]}

\item{flavors}{list of dimensionality reduction algorithms to try.
Currently the options are "pca", "tsne" and "umap"}

\item{is.counts}{logical: is exprs count data}
}
\value{
name of dimensionality reduction method that gives the highest
           2d entropy
}
\description{
Pick the dimensionality reduction method for a dataset that gives the
2D embedding with the highest entropy
}
\examples{
x <- matrix(rnbinom(60000, size=1, prob = .1), ncol=100)
pickDimReduction(x)
}
