% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nempi_main.r
\name{nempibs}
\alias{nempibs}
\title{Bootstrapping function}
\usage{
nempibs(D, bsruns = 100, bssize = 0.5, replace = TRUE, ...)
}
\arguments{
\item{D}{either a binary effects matrix or log odds matrix as}

\item{bsruns}{number of bootstraps}

\item{bssize}{number of E-genes for each boostrap}

\item{replace}{if TRUE, actual bootstrap, if False sub-sampling}

\item{...}{additional parameters for the function nempi}
}
\value{
list with aggregate Gamma and aggregate causal network phi
}
\description{
Bootstrap algorithm to get a more stable result.
}
\examples{
D <- matrix(rnorm(1000*100), 1000, 100)
colnames(D) <- sample(seq_len(5), 100, replace = TRUE)
Gamma <- matrix(sample(c(0,1), 5*100, replace = TRUE, p = c(0.9, 0.1)), 5,
100)
Gamma <- apply(Gamma, 2, function(x) return(x/sum(x)))
Gamma[is.na(Gamma)] <- 0
rownames(Gamma) <- seq_len(5)
result <- nempibs(D, bsruns = 3, Gamma = Gamma)
}
\author{
Martin Pirkl
}
