% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndex_connect.r
\name{ndex_connect}
\alias{ndex_connect}
\title{Connect to NDEx REST API}
\usage{
ndex_connect(
  username,
  password,
  host = ndexConf$connection$host,
  apiPath = ndexConf$connection$api,
  ndexConf = ndex_config,
  verbose = FALSE
)
}
\arguments{
\item{username}{character (optional); username}

\item{password}{character (optional); password}

\item{host}{character (default: ndexConf$connection$host); Host address of NDEx server; By default the url set in ndexConf$defaults$connection$host is used. ("http://www.ndexbio.org")}

\item{apiPath}{character (default: ndexConf$connection$api); URL path of the REST api; By default the url set in ndexConf$defaults$connection$api is used. ("/v2" for NDEx version 2.0, "/rest" for NDEx version 1.3)}

\item{ndexConf}{config object (nested list, default: ndex_config); Configuration of NDEx REST server; Set in ndex_config (set in ndex_api_config.r or ndex_api_config.yml): It contains specifications for NDEx server api version 1.3 and 2.0. The default api is specified by 'defaultVersion'}

\item{verbose}{logical (optional); whether to print out extended feedback}
}
\value{
returns object of class NDExConnection which stores options, authentication and api configuration if successfull, NULL otherwise
}
\description{
This function creates an NDExConnection which stores options and authentication details. It is a parameter required for most of the other ndexr functions.
If username and password are missing an anonymous connection is created, which already offers most of the retrieval functionality.
}
\examples{
## log in anonymously
ndexcon = ndex_connect()
## same as above with extended feedback
ndexcon = ndex_connect(verbose=TRUE)
\dontrun{
## log in with credentials
ndexcon = ndex_connect('user','password')
## running some NDEx server locally
ndexcon = ndex_connect(host='localhost:8765')
## manually change the api and connection configuration
ndexcon = ndex_connect(ndexConf=ndex_config$Version_2.0)   
}
}
\seealso{
\code{\link{ndex_config}}
}
