% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_signatures.R
\name{plot_signatures}
\alias{plot_signatures}
\title{Plots the mutational signatures}
\usage{
plot_signatures(
  musica,
  model_id,
  modality = "SBS96",
  result_name = "result",
  color_variable = NULL,
  color_mapping = NULL,
  text_size = 10,
  show_x_labels = TRUE,
  show_y_labels = TRUE,
  same_scale = FALSE,
  y_max = NULL,
  annotation = NULL,
  percent = TRUE,
  plotly = FALSE
)
}
\arguments{
\item{musica}{A \code{\linkS4class{musica}} object containing a mutational
discovery or prediction.}

\item{model_id}{The name of the model to plot.}

\item{modality}{The modality of the signatures to plot. Must be
"SBS96", "DBS78", or "IND83". Default \code{"SBS96"}.}

\item{result_name}{Name of the result list entry containing the signatures
to plot. Default \code{"result"}.}

\item{color_variable}{Name of the column in the variant annotation data.frame
to use for coloring the mutation type bars. The variant annotation data.frame
can be found within the count table of the \code{\linkS4class{musica}}
object. If \code{NULL}, then the default column specified in the count
table will be used. Default \code{NULL}.}

\item{color_mapping}{A character vector used to map items in the
\code{color_variable} to a color. The items in \code{color_mapping}
correspond to the colors. The names of the items in \code{color_mapping}
should correspond to the unique items in \code{color_variable}. If
\code{NULL}, then the default \code{color_mapping} specified in the count
table will be used. Default \code{NULL}.}

\item{text_size}{Size of axis text. Default \code{10}.}

\item{show_x_labels}{If \code{TRUE}, the labels for the mutation types
on the x-axis will be shown. Default \code{TRUE}.}

\item{show_y_labels}{If \code{TRUE}, the y-axis ticks and labels will be
shown. Default \code{TRUE}.}

\item{same_scale}{If \code{TRUE}, the scale of the probability for each
signature will be the same. If \code{FALSE}, then the scale of the y-axis
will be adjusted for each signature. Default \code{FALE}.}

\item{y_max}{Vector of maximum y-axis limits for each signature. One value
may also be provided to specify a constant y-axis limit for all signatures.
Vector length must be 1 or equivalent to the number of signatures. Default
\code{NULL}.}

\item{annotation}{Vector of annotations to be displayed in the top right
corner of each signature. Vector length must be equivalent to the number of
signatures. Default \code{NULL}.}

\item{percent}{If \code{TRUE}, the y-axis will be represented in percent
format instead of mutation counts. Default \code{TRUE}.}

\item{plotly}{If \code{TRUE}, the the plot will be made interactive
using \code{\link[plotly]{plotly}}. Default \code{FALSE}.}
}
\value{
Generates a ggplot or plotly object
}
\description{
After mutational signature discovery has been performed, this function
can be used to display the distribution of each mutational signature. The
\code{color_variable} and \code{color_mapping} parameters can be used
to change the default color scheme of the bars.
}
\examples{
data(res)
plot_signatures(res, model_id = "res")
}
