% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_result_model.R
\name{num_signatures}
\alias{num_signatures}
\alias{num_signatures,musica-method}
\alias{num_signatures,result_collection-method}
\alias{num_signatures,result_model-method}
\alias{num_signatures<-}
\alias{num_signatures<-,musica,matrix-method}
\alias{num_signatures<-,result_collection,matrix-method}
\alias{num_signatures<-,result_model,matrix-method}
\title{Retrieve num_signatures from a result_model, result_collection, or
musica object}
\usage{
num_signatures(x, ...)

\S4method{num_signatures}{musica}(x, result, modality, model_id)

\S4method{num_signatures}{result_collection}(x, modality, model_id)

\S4method{num_signatures}{result_model}(x)

num_signatures(x, ...) <- value

\S4method{num_signatures}{musica,matrix}(x, result, modality, model_id) <- value

\S4method{num_signatures}{result_collection,matrix}(x, modality, model_id) <- value

\S4method{num_signatures}{result_model,matrix}(x) <- value
}
\arguments{
\item{x}{A \code{\linkS4class{musica}},
\code{\linkS4class{result_collection}}, or \code{\linkS4class{result_model}}
object generated by a mutational discovery or prediction tool.}

\item{...}{Other inputs}

\item{result}{Name of result from result_list to assign the num_signatures.
Used when \code{result} is a \code{\linkS4class{musica}} object.}

\item{modality}{Modality to assign the num_signatures. Used when
\code{result} is a \code{\linkS4class{musica}} or
\code{\linkS4class{result_collection}} object.}

\item{model_id}{Model identifier to assign the num_signatures. Used when
\code{result} is a \code{\linkS4class{musica}} or
\code{\linkS4class{result_collection}} object.}

\item{value}{Number of signatures in the model}
}
\value{
The number of signatures in a model
}
\description{
The number of signatures in a model
}
\examples{
data(res)
num_signatures(res, "result", "SBS96", "res")
}
