% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{extract_variants_from_vcf}
\alias{extract_variants_from_vcf}
\title{Extracts variants from a VariantAnnotation VCF object}
\usage{
extract_variants_from_vcf(
  vcf,
  id = NULL,
  rename = NULL,
  sample_field = NULL,
  filter = TRUE,
  multiallele = c("expand", "exclude"),
  extra_fields = NULL
)
}
\arguments{
\item{vcf}{Location of vcf file}

\item{id}{ID of the sample to select from VCF. If \code{NULL}, then the
first sample will be selected. Default \code{NULL}.}

\item{rename}{Rename the sample to this value when extracting variants.
If \code{NULL}, then the sample will be named according to \code{ID}.}

\item{sample_field}{Some algoriths will save the name of the
sample in the ##SAMPLE portion of header in the VCF (e.g.
##SAMPLE=<ID=TUMOR,SampleName=TCGA-01-0001>). If the ID is specified via the
\code{id} parameter ("TUMOR" in this example), then \code{sample_field} can
be used to specify the name of the tag ("SampleName" in this example).
Default \code{NULL}.}

\item{filter}{Exclude variants that do not have a \code{PASS} in the
\code{FILTER} column of the VCF. Default \code{TRUE}.}

\item{multiallele}{Multialleles are when multiple alternative variants
are listed in the same row in the vcf. One of \code{"expand"} or
\code{"exclude"}. If \code{"expand"} is selected, then each
alternate allele will be given their own rows. If \code{"exclude"} is
selected, then these rows will be removed. Default \code{"expand"}.}

\item{extra_fields}{Optionally extract additional fields from the \code{INFO}
section of the VCF. Default \code{NULL}.}
}
\value{
Returns a data.table of variants from a vcf
}
\description{
Aaron - Need to describe differnce between ID, and name in the header, and
rename in terms of naming the sample. Need to describe differences in
multiallelic choices. Also need to describe the automatic error fixing
}
\examples{
vcf_file <- system.file("extdata", "public_LUAD_TCGA-97-7938.vcf",
  package = "musicatk"
)

library(VariantAnnotation)
vcf <- readVcf(vcf_file)
variants <- extract_variants_from_vcf(vcf = vcf)
}
