% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepSCE.R
\name{prepSCE}
\alias{prepSCE}
\title{Prepare SCE for DS analysis}
\usage{
prepSCE(
  x,
  kid = "cluster_id",
  sid = "sample_id",
  gid = "group_id",
  drop = FALSE
)
}
\arguments{
\item{x}{a \linkS4class{SingleCellExperiment}.}

\item{kid, sid, gid}{character strings specifying
the \code{colData(x)} columns containing cluster assignments,
unique sample identifiers, and group IDs (e.g., treatment).}

\item{drop}{logical. Specifies whether \code{colData(x)} columns
besides those specified as \code{cluster_id,sample_id,group_id}
should be retained (default \code{drop = FALSE}) 
or removed (\code{drop = TRUE}).}
}
\value{
a \linkS4class{SingleCellExperiment}.
}
\description{
...
}
\examples{
# generate random counts
ng <- 50
nc <- 200
    
# generate some cell metadata
gids <- sample(c("groupA", "groupB"), nc, TRUE)   
sids <- sample(paste0("sample", seq_len(3)), nc, TRUE) 
kids <- sample(paste0("cluster", seq_len(5)), nc, TRUE) 
batch <- sample(seq_len(3), nc, TRUE)
cd <- data.frame(group = gids, id = sids, cluster = kids, batch)

# construct SCE
library(scuttle)
sce <- mockSCE(ncells = nc, ngenes = ng)
colData(sce) <- cbind(colData(sce), cd)

# prep. for workflow
sce <- prepSCE(sce, kid = "cluster", sid = "id", gid = "group")
head(colData(sce))
metadata(sce)$experiment_info
sce

}
\author{
Helena L Crowell
}
