% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replaceNAs.R
\name{replaceNAs}
\alias{replaceNAs}
\title{Return multistateQTL object with NAs filled in}
\usage{
replaceNAs(
  object,
  methods = list(betas = 0, errors = "mean", pvalues = 1, lfsrs = 1),
  verbose = FALSE
)
}
\arguments{
\item{object}{A `QTLExperiment` object}

\item{methods}{A named list with the method for each assay. Available methods
are to replace with a given integer or with the row mean or median.}

\item{verbose}{logical. Whether to print progress messages.}
}
\value{
A `QTLExperiment` object with the same dimensions as the original object,
  but with the NA values replaced according to the input specifications.
}
\description{
A convenience function for imputing or filling in NAs in a `QTLExperiment`
object.
}
\examples{

#' # Create a QTLExperiment object with NA values ------------------------------
qtle <- mockQTLE()
    
# Randomly remove 1000 elements from the betas matrix.
na_pattern <- sample(seq(1, ncol(qtle)*nrow(qtle)), 1000)
qtle_na <- qtle
assay(qtle_na, "betas")[na_pattern] <- NA

# There are some NA values in the "betas" assay
any(is.na(betas(qtle_na)))

qtle_complete <- replaceNAs(qtle_na)

# Now we don't have any NA values
any(is.na(betas(qtle_complete)))

## Specify a specific method to impute NAs ----------------------------------

qtle_median <- replaceNAs(
    qtle_na, 
    methods=list(betas = 0, errors = "median", pvalues = 1), 
    verbose=TRUE)

}
