% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalFunctions.R
\name{iterate}
\alias{iterate}
\title{iterate: Iterate function across networks}
\usage{
iterate(WGCNAlist, FUN, ...)
}
\arguments{
\item{WGCNAlist}{a vector of objects of type WGCNAobject}

\item{FUN}{function to iterate, either overlapComparisons or preservationComparisons}

\item{...}{argmuents to be passed on to overlapComparisons or preservationComparisons}
}
\value{
a comparison list from overlapComparisons or preservationComparisons
}
\description{
A high level function that iterates functions across
a list of WGCNA objects
}
\examples{
library(ExperimentHub)
eh = ExperimentHub()
eh_query = query(eh, c("multiWGCNAdata"))
astrocyte_networks = eh_query[["EH8222"]]
results = list()
iterate(astrocyte_networks, overlapComparisons, plot=FALSE)

}
\author{
Dario Tommasini
}
