% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.R
\name{drawMultiWGCNAnetwork}
\alias{drawMultiWGCNAnetwork}
\title{Draw multiWGCNA network}
\usage{
drawMultiWGCNAnetwork(
  WGCNAlist,
  comparisonList,
  moduleOfInterest,
  design,
  overlapCutoff = 0,
  padjCutoff = 1,
  removeOutliers = TRUE,
  alpha = 1e-50,
  layout = NULL,
  hjust = 0.4,
  vjust = 0.3,
  width = 0.5,
  colors = NULL
)
}
\arguments{
\item{WGCNAlist}{list of WGCNA objects}

\item{comparisonList}{the list of overlap comparisons ie from iterate(myNetworks, overlapComparisons, ...)}

\item{moduleOfInterest}{module of interest, ie "combined_001"}

\item{design}{the sampleTable design matrix}

\item{overlapCutoff}{cutoff to remove module correspondences with less than this number of genes}

\item{padjCutoff}{cutoff to remove module correspondences above this significance value}

\item{removeOutliers}{remove outlier modules?}

\item{alpha}{alpha level of significance}

\item{layout}{layout of network to be passed to plot function of igraph object, defaults to multiWGCNA custom layout}

\item{hjust}{horizontal justification of labels}

\item{vjust}{vertical justification of labels}

\item{width}{width of labels}

\item{colors}{colors to use for modules, should be the same length as the number of WGCNA objects in the WGCNAlist. Defaults to random colors for each condition.}
}
\value{
an igraph plot
}
\description{
Draw a network where nodes are modules and edges represent significant gene overlap. 
Modules are sorted by levels 1, 2, and 3.
}
\examples{
library(ExperimentHub)
eh = ExperimentHub()
eh_query = query(eh, c("multiWGCNAdata"))
astrocyte_se = eh_query[["EH8223"]]
sampleTable = colData(astrocyte_se)
astrocyte_networks = eh_query[["EH8222"]]
results = list()
results$overlaps = iterate(astrocyte_networks, overlapComparisons, plot=FALSE)
drawMultiWGCNAnetwork(astrocyte_networks, 
  results$overlaps, 
  "combined_013", 
  sampleTable)
  
}
\author{
Dario Tommasini
}
