% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlaps.R
\name{computeOverlapsFromWGCNA}
\alias{computeOverlapsFromWGCNA}
\title{computeOverlapsFromWGCNA}
\usage{
computeOverlapsFromWGCNA(dataset1, dataset2)
}
\arguments{
\item{dataset1}{an object of class WGCNA to compare with dataset2}

\item{dataset2}{an object of class WGCNA to compare with dataset1}
}
\value{
Returns a data.frame showing the overlap results for modules from 
dataset1 with dataset2
}
\description{
Computes overlap between the modules of two objects of class WGCNA
}
\examples{
library(ExperimentHub)
eh = ExperimentHub()
eh_query = query(eh, c("multiWGCNAdata"))
astrocyte_networks = eh_query[["EH8222"]]
computeOverlapsFromWGCNA(astrocyte_networks$EAE, astrocyte_networks$WT)

}
\author{
Dario Tommasini
}
