% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalFunctions.R
\name{cleanDatExpr}
\alias{cleanDatExpr}
\title{cleanDatExpr}
\usage{
cleanDatExpr(datExpr, checkGenesSamples = FALSE)
}
\arguments{
\item{datExpr}{a data.frame were columns are samples and rows are samples and the gene symbols are in the first row}

\item{checkGenesSamples}{call the WGCNA function checkGenesSamples?}
}
\value{
Returns a datExpr with rows as samples and columns as genes
}
\description{
A function that converts a data.frame where row 1 is gene symbols to a 
numeric matrix where columns are genes and rows are samples for compatibility 
with most WGCNA functions.
}
\examples{
library(ExperimentHub)
eh = ExperimentHub()
eh_query = query(eh, c("multiWGCNAdata"))
astrocyte_se = eh_query[["EH8223"]]
datExpr = data.frame(X = rownames(assays(astrocyte_se)[[1]]), assays(astrocyte_se)[[1]])
cleanDatExpr(datExpr)

}
\author{
Dario Tommasini
}
