% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlaps.R
\name{ModuleFlowPlot2Way}
\alias{ModuleFlowPlot2Way}
\title{Module sankey diagram}
\usage{
ModuleFlowPlot2Way(
  overlapDf,
  dataset1,
  dataset2,
  only.signif = TRUE,
  show.legend = TRUE,
  col = NULL,
  ...
)
}
\arguments{
\item{overlapDf}{a data.frame resulting from a call to computeOverlapsFromWGCNA}

\item{dataset1}{an object of class WGCNA to compare with dataset2}

\item{dataset2}{an object of class WGCNA to compare with dataset1}

\item{only.signif}{plot only significant overlap?}

\item{show.legend}{show the legend?}

\item{col}{color palette, default is internal colors function}

\item{...}{params to GetSignificantOverlap function for thresholds}
}
\value{
Returns a ggalluvial diagram comparing two networks
}
\description{
A plotting function that returns a sankey plot comparing two networks. 
This is a deprecated function, please use ModuleFlowPlot instead.
}
\examples{
library(ExperimentHub)
eh = ExperimentHub()
eh_query = query(eh, c("multiWGCNAdata"))
astrocyte_networks = eh_query[["EH8222"]]
overlapDf = computeOverlapsFromWGCNA(astrocyte_networks$EAE, astrocyte_networks$WT)
ModuleFlowPlot2Way(overlapDf, astrocyte_networks$EAE, astrocyte_networks$WT)
}
\author{
Dario Tommasini
}
