% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlaps.R
\name{ModuleFlowPlot}
\alias{ModuleFlowPlot}
\title{Module sankey diagram}
\usage{
ModuleFlowPlot(
  WGCNAlist,
  comparisonList,
  networks,
  labels = NULL,
  alpha = 1,
  x.scale = 2,
  y.scale = 1,
  width = 0.3,
  height = 0.2,
  color.by = c("trait", "network", "none"),
  color.low = "cyan",
  color.high = "magenta",
  col = NULL,
  my_layout = NULL,
  use.padj = FALSE,
  only.contiguous = TRUE,
  only.signif = TRUE,
  show.legend = TRUE,
  scale.by.size = TRUE,
  spacer = 10,
  label.y = 50,
  label.size = 4,
  base_family = "Helvetica",
  p.adj.threshold = 0.05,
  overlap.threshold = 10
)
}
\arguments{
\item{WGCNAlist}{a data.frame resulting from a call to computeOverlapsFromWGCNA}

\item{comparisonList}{an object of class WGCNA to compare with dataset2}

\item{networks}{an object of class WGCNA to compare with dataset1}

\item{labels}{labels to show under each networks}

\item{alpha}{alpha value for the node tiles, default is 1}

\item{x.scale}{x spacing parameter}

\item{y.scale}{y spacing parameter}

\item{width}{width of the block}

\item{height}{height of the block}

\item{color.by}{color fill for nodes, either 'network', 'trait', or NULL}

\item{color.low}{default is cyan}

\item{color.high}{default is magenta}

\item{col}{color palette for node tiles, default is internal colors function}

\item{my_layout}{pass a custom layout for nodes? Default is null}

\item{use.padj}{use p.adj for edge width, default is false (use gene overlap value)}

\item{only.contiguous}{only show continuous overlaps? Default is TRUE}

\item{only.signif}{plot only significant overlap?}

\item{show.legend}{show the legend?}

\item{scale.by.size}{scale the node height by the size of the module? Default is TRUE.}

\item{spacer}{space between the nodes}

\item{label.y}{adjust the y coordinate for the network labels, default is 1}

\item{label.size}{size of the node labels, default is 4}

\item{base_family}{font family for ggraph}

\item{p.adj.threshold}{adjusted p-value significance threshold for overlap}

\item{overlap.threshold}{threshold for number of genes overlapping}
}
\value{
Returns a ggalluvial diagram comparing two networks
}
\description{
A plotting function that returns a plot
}
\examples{
library(ExperimentHub)
eh = ExperimentHub()
eh_query = query(eh, c("multiWGCNAdata"))
astrocyte_networks = eh_query[["EH8222"]]
results = list()
results$overlaps = iterate(astrocyte_networks, overlapComparisons, plot=FALSE)
ModuleFlowPlot(astrocyte_networks, results$overlaps, c('combined',  'EAE', 'WT'))
}
\author{
Dario Tommasini
}
