% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genie3.R
\name{genie3}
\alias{genie3}
\title{Run GENIE3}
\usage{
genie3(
  expr.matrix,
  ngene = NULL,
  K = "sqrt",
  nb.trees = 1000,
  input.idx = NULL,
  importance.measure = "IncNodePurity",
  trace = FALSE,
  ...
)
}
\arguments{
\item{expr.matrix}{exrepssion matrix (genes by samples).}

\item{ngene}{an integer, only up to the first ngene (included) targets (responsible variables).}

\item{K}{choice of number of input genes randomly, must be one of "sqrt", "all", an integar.}

\item{nb.trees}{number of trees in ensemble for each target gene (default 1000).}

\item{input.idx}{subset of genes used as input genes (default all genes). A vector of indices or gene names is accepted.}

\item{importance.measure}{type of variable importance measure, "IncNodePurity" or "\%IncMSE".}

\item{trace}{index of currently computed gene is reported (default FALSE).}

\item{...}{parameter to randomForest.}
}
\value{
A weighted adjacency matrix of inferred network, element w_ij (row i, column j) gives the importance of the link from regulatory gene i to target gene j.
}
\description{
Calculate the weight matrix between genes via randomForest, modified from original codes by Huynh-Thu, V.A.
}
\examples{
#- Toy examples.
mtx <- matrix(sample(1000, 100), nrow = 5)
mtx <- rbind(mtx[1, ] * 2 + rnorm(20), mtx)
colnames(mtx) <- paste0("s_", seq_len(ncol(mtx)))
rownames(mtx) <- paste0("g_", seq_len(nrow(mtx)))
res <- genie3(mtx, nb.trees = 100)
}
\references{
Huynh-Thu, V.A., Irrthum, A., Wehenkel, L., and Geurts, P. (2010). Inferring Regulatory Networks from Expression Data Using Tree-Based Methods. PLoS ONE 5, e12776.
}
