% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compensationSLP.R
\name{comp_slp}
\alias{comp_slp}
\title{Identify SLPs via compensation}
\usage{
comp_slp(
  zscore_data,
  mut_data,
  mutgene = NULL,
  positive_perc = 0.5,
  p_thresh = 0.01,
  ...
)
}
\arguments{
\item{zscore_data}{a matrix (genes by patients) reflecting gene expression related to wide type samples. For example, generated from \code{\link{pp_tcga}}.}

\item{mut_data}{a data.table with columns "patientid" and "mut_entrez".}

\item{mutgene}{identify SLPs for sepecific muatation (gene symbols). If NULL (by default), the intersection genes between zscore_data and mut_data are used.}

\item{positive_perc}{keep genes with postive zscore in at least positive_perc * number of mutation patients.}

\item{p_thresh}{pvalue threshold to filter out results.}

\item{...}{additional parameters to \code{\link[RankProd]{RankProducts}}.}
}
\value{
A data.table with predicted SLPs.
  \describe{
    \item{mut_entrez}{Entrez ids of mutations.}
    \item{mut_symbol}{Gene symbols of mutations.}
    \item{slp_entrez}{Entrez ids of SLPs.}
    \item{slp_symbol}{Gene symbols of SLPs.}
    \item{pvalue}{p_value from \code{\link[RankProd]{RankProducts}}.}
    \item{fdr}{"BH" adjusted pvalue via \code{\link[stats]{p.adjust}}.}
}
}
\description{
Identify SLPs compensating for the loss of function of mutations. The up-regulated SLPs are selected via the rank prodcuts algorithm, with option calculateProduct = FALSE for a robust results and capacity on large datasets.
}
\examples{
#- Toy examples, see vignette for more.
#- Add the parallel backend.
require(future)
require(doFuture)
plan(multisession, workers = 2)
data("example_z")
data("example_comp_mut")
res <- comp_slp(example_z, example_comp_mut)
plan(sequential)
}
