% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purityD-dims-purity.R
\name{dimsPredictPuritySingle}
\alias{dimsPredictPuritySingle}
\title{Predict the precursor purity from a DI-MS dataset}
\usage{
dimsPredictPuritySingle(
  mztargets,
  filepth,
  minOffset = 0.5,
  maxOffset = 0.5,
  ppm = 2.5,
  mzML = TRUE,
  iwNorm = FALSE,
  iwNormFun = NULL,
  ilim = 0.05,
  mzRback = "pwiz",
  isotopes = TRUE,
  im = NULL,
  sim = FALSE
)
}
\arguments{
\item{mztargets}{vector = mz targets to get predicted purity for}

\item{filepth}{character = mzML file path or .csv file path}

\item{minOffset}{numeric = isolation window minimum offset}

\item{maxOffset}{numeric = isolation window maximum offset}

\item{ppm}{numeric = tolerance for target mz value in each scan}

\item{mzML}{boolean = Whether an mzML file is to be used or .csv file (TRUE == mzML)}

\item{iwNorm}{boolean = if TRUE then the intensity of the isolation window will be normalised based on the iwNormFun function}

\item{iwNormFun}{function = A function to normalise the isolation window intensity. The default function is very generalised and just accounts for edge effects}

\item{ilim}{numeric = All peaks less than this percentage of the target peak will be removed from the purity calculation, default is 5\% (0.05)}

\item{mzRback}{character = backend to use for mzR parsing}

\item{isotopes}{boolean = TRUE if isotopes are to be removed}

\item{im}{matrix = Isotope matrix, default removes C13 isotopes (single, double and triple bonds)}

\item{sim}{boolean = TRUE if file is from sim stitch experiment. Default FALSE}
}
\value{
a dataframe of the target mz values and the predicted purity score
}
\description{
Given a an DI-MS dataset (either mzML or .csv file) calculate the predicted
purity for a vector of mz values.

Calculated at a given offset e.g. for 0.5 +/- Da the minOffset would be 0.5
and the maxOffset of 0.5.

A ppm tolerance is used to find the target mz value in each scan.
}
\examples{
mzmlPth <- system.file("extdata", "dims", "mzML", "B02_Daph_TEST_pos.mzML",
                       package="msPurityData")
predicted <- dimsPredictPuritySingle(c(173.0806, 216.1045), filepth=mzmlPth,
                             minOffset=0.5, maxOffset=0.5, ppm=5, mzML=TRUE)
}
