% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineAnnotations.R
\name{combineAnnotations}
\alias{combineAnnotations}
\title{Combine Annotations}
\usage{
combineAnnotations(
  sm_resultPth,
  compoundDbPth,
  metfrag_resultPth = NA,
  sirius_csi_resultPth = NA,
  probmetab_resultPth = NA,
  ms1_lookup_resultPth = NA,
  ms1_lookup_dbSource = "hmdb",
  ms1_lookup_checkAdducts = FALSE,
  ms1_lookup_keepAdducts = c("[M+H]+", "[M-H]-"),
  weights = list(sm = 0.3, metfrag = 0.2, sirius_csifingerid = 0.2, probmetab = 0,
    ms1_lookup = 0.05, biosim = 0.25),
  compoundDbType = "sqlite",
  compoundDbName = NA,
  compoundDbHost = NA,
  compoundDbPort = NA,
  compoundDbUser = NA,
  compoundDbPass = NA,
  outPth = NA,
  summaryOutput = TRUE
)
}
\arguments{
\item{sm_resultPth}{character; Path to the msPurity SQLite database used for spectral matching}

\item{compoundDbPth}{character; Path to local compound database with pubchem, hmdb, KEGG and metab_compound summary table
(full database available on request - contact t.n.lawson@bham.ac.uk).
This is only applicable if using "compoundDbType sqlite")}

\item{metfrag_resultPth}{character; Path to the tsv table of metfrag results}

\item{sirius_csi_resultPth}{character; Path to the tsv table of Sirius CSI:Finger ID results}

\item{probmetab_resultPth}{character; Path to the tsv table of Probmetab results}

\item{ms1_lookup_resultPth}{character; Path to generic tsv table of MS1 lookup results}

\item{ms1_lookup_dbSource}{character; Source of the compound database used for ms1_lookup
(currently only supports HMDB, KEGG or PubChem)}

\item{ms1_lookup_checkAdducts}{boolean; Check if adducts match to those found in CAMERA (requires the database to have been created with CAMERA object)}

\item{ms1_lookup_keepAdducts}{vecotr; Keep only adducts found from the MS1 lookup that are found in this vector}

\item{weights}{list;}

\item{compoundDbType}{character; Database type for compound database can be either (sqlite, postgres or mysql)}

\item{compoundDbName}{character; Database name (only applicable for postgres and mysql)}

\item{compoundDbHost}{character; Database host (only applicable for postgres and mysql)}

\item{compoundDbPort}{character; Database port (only applicable for postgres and mysql)}

\item{compoundDbUser}{character; Database user (only applicable for postgres and mysql)}

\item{compoundDbPass}{character; Database pass (only applicable for postgres and mysql) - Note this is not secure!}

\item{outPth}{character;}

\item{summaryOutput}{boolean; If a summary dataframe is to be created}
}
\value{
purityA object with slots for fragmentation-XCMS links
}
\description{
Combine the annotation results from msPurity spectral matching, MetFrag, Sirius CSI:FingerID, probmetab and any generic
MS1 lookup software (e.g. results from the BEAMS software)

The annotation results are then aligned by inchikey and XCMS grouped feature.

The tool has to be run with a local compound database (available on request - contact t.n.lawson@bham.ac.uk)
}
\examples{
metfrag_resultPth <- system.file("extdata", "tests", "external_annotations",
                                      "metfrag.tsv", package="msPurity")
# run the standard spectral matching workflow to get the sm_resultPth
sm_resultPth <- system.file("extdata","tests", "sm",
                        "spectralMatching_result.sqlite", package="msPurity")
compoundDbPth <- system.file("extdata", "tests", "db",
                          "metab_compound_subset.sqlite", package="msPurity")
combined <- combineAnnotations(sm_resultPth,
                             metfrag_resultPth,
                             outPth=file.path(tempdir(), 'combined.sqlite'),
                             compoundDbPth=compoundDbPth)
}
