% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comppoiss_wrapper.R
\name{compoundPoissonDist}
\alias{compoundPoissonDist}
\title{Compound Poisson Approximation}
\usage{
compoundPoissonDist(seqlen, overlap, method = "kopp")
}
\arguments{
\item{seqlen}{Integer-valued vector that defines the lengths of the
individual sequences. For a given DNAStringSet, 
this information can be retrieved using \code{\link{numMotifHits}}.}

\item{overlap}{An Overlap object.}

\item{method}{String that defines which method shall be invoked: 'pape' or
'kopp' (see description). Default: method = 'kopp'.}
}
\value{
List containing
\describe{
\item{dist}{Distribution of the number of hits}
}
}
\description{
This function approximates the distribution of the number of motif hits
that emerges from a random DNA sequence of a given length.
}
\details{
The distribution can be determined in two alternative ways:
\enumerate{
\item A re-implemented version of the algorithm that was
described in Pape et al. \emph{Compound poisson approximation
of the number of occurrences of a position
frequency matrix (PFM) on both strands.} 2008
can be invoked using method='pape'.
The main purpose of this implementation concerns 
benchmarking an improved approximation.
In contrast to the original model, this implementation 
can be used with general order-d Markov models.
\item We provide an improved compound Poisson approximation that
uses more appropriate statistical assumptions concerning
overlapping motif hits and that can be used with order-d
background models as well. The improved version is used by default
with method='kopp'.
Note: Only method='kopp' supports the computation
of the distribution of the number of motif hits w.r.t. scanning
a single DNA strand (see \code{\link{probOverlapHit}}).
}
}
\examples{

# Load sequences
seqfile = system.file("extdata", "seq.fasta", package = "motifcounter")
seqs = Biostrings::readDNAStringSet(seqfile)

# Load motif
motiffile = system.file("extdata", "x31.tab", package = "motifcounter")
motif = t(as.matrix(read.table(motiffile)))

# Load background model
bg = readBackground(seqs, 1)

# Use 100 individual sequences of length 150 bp each
seqlen = rep(150, 100)

# Compute overlapping probabilities
# for scanning the forward DNA strand only
op = motifcounter:::probOverlapHit(motif, bg, singlestranded = TRUE)

# Computes  the compound Poisson distribution
dist = motifcounter:::compoundPoissonDist(seqlen, op)
#plot(1:length(dist$dist)-1, dist$dist)

# Compute overlapping probabilities
# for scanning the forward DNA strand only
op = motifcounter:::probOverlapHit(motif, bg, singlestranded = FALSE)

# Computes  the compound Poisson distribution
dist = motifcounter:::compoundPoissonDist(seqlen, op)
#plot(1:length(dist$dist)-1, dist$dist)

}
\seealso{
\code{\link{combinatorialDist}}

\code{\link{probOverlapHit}}

\code{\link{numMotifHits}}
}
