% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comppoiss_wrapper.R
\name{clumpSizeDist}
\alias{clumpSizeDist}
\title{Clump size distribution}
\usage{
clumpSizeDist(maxclump, overlap, method = "kopp")
}
\arguments{
\item{maxclump}{Maximal clump size}

\item{overlap}{An Overlap object.}

\item{method}{String that defines which method shall be invoked: 'pape' or
'kopp' (see description). Default: method = 'kopp'.}
}
\value{
List containing
\describe{
\item{dist}{Distribution of the clump size}
}
}
\description{
This function approximates the distribution of the clump sizes.
}
\details{
The clump size distribution can be determined in two alternative ways:
\enumerate{
\item A re-implemented version of the algorithm that was
described in Pape et al. \emph{Compound poisson approximation
of the number of occurrences of a position
frequency matrix (PFM) on both strands.} 2008
can be invoked using method='pape'.
\item An improved approximation of the clump size distribution 
uses more appropriate statistical assumptions concerning
overlapping motif hits and that can be used with order-d
background models as well. The improved version is used by default
with method='kopp'.
}
}
\examples{

# Load sequences
seqfile = system.file("extdata", "seq.fasta", package = "motifcounter")
seqs = Biostrings::readDNAStringSet(seqfile)

# Load motif
motiffile = system.file("extdata", "x31.tab", package = "motifcounter")
motif = t(as.matrix(read.table(motiffile)))

# Load background model
bg = readBackground(seqs, 1)

# Use 100 individual sequences of length 150 bp each
seqlen = rep(150, 100)


# Compute overlapping probabilities
# for scanning the forward DNA strand only
op = motifcounter:::probOverlapHit(motif, bg, singlestranded = FALSE)

# Computes  the compound Poisson distribution
dist = motifcounter:::clumpSizeDist(20, op)

}
\seealso{
\code{\link{probOverlapHit}}
}
