% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMotifLogo.R
\name{plotMotifLogo}
\alias{plotMotifLogo}
\title{plot sequence logo}
\usage{
plotMotifLogo(
  pfm,
  motifName,
  p = rep(0.25, 4),
  font = "sans",
  fontface = "bold",
  colset = c("#00811B", "#2000C7", "#FFB32C", "#D00001"),
  xaxis = TRUE,
  yaxis = TRUE,
  xlab = "position",
  ylab = "bits",
  xlcex = 1.2,
  ylcex = 1.2,
  ncex = 1.2,
  ic.scale = TRUE,
  newpage = TRUE,
  margins = c(4.1, 4.1, 2.1, 0.1),
  draw = TRUE,
  ...
)
}
\arguments{
\item{pfm}{a position frequency matrices}

\item{motifName}{motif name}

\item{p}{background possibility}

\item{font}{font of logo}

\item{fontface}{fontface of logo}

\item{colset}{color setting for each logo letter}

\item{xaxis}{draw x-axis or not. If a vector of character or numeric is
provided, the function will try to plot the x-axis by setting the labels
as the vectors.}

\item{yaxis}{draw y-axis or not}

\item{xlab}{x-label, do nothing if set xlab as NA}

\item{ylab}{y-label, do nothing if set ylab as NA}

\item{xlcex}{cex value for x-label}

\item{ylcex}{cex value for y-label}

\item{ncex}{cex value for motif name}

\item{ic.scale}{logical If TRUE, the height of each column is proportional
to its information content. Otherwise, all columns have the same height.
It will also can be set as FALSE followed by a numeric vectors.
The format is c(FALSE, scale).
If it is FALSE followed by a number (eg c(FALSE, 100)), 
the y axis labels will be re-scaled by 100.}

\item{newpage}{logical If TRUE, plot it in a new page.}

\item{margins}{A numeric vector interpreted in the same way as par(mar) in
base graphics.}

\item{draw}{Vector (logical(1)). TRUE to plot. FALSE, return a gList}

\item{...}{Not used.}
}
\value{
none
}
\description{
plot amino acid or DNA sequence logo
}
\examples{

pcm<-matrix(runif(40,0,100),nrow=4,ncol=10)
pfm<-pcm2pfm(pcm)
rownames(pfm)<-c("A","C","G","T")
plotMotifLogo(pfm)

}
