% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importMatrix.R
\name{importMatrix}
\alias{importMatrix}
\title{import motifs from local files}
\usage{
importMatrix(
  filenames,
  format = c("auto", "pfm", "cm", "pcm", "meme", "transfac", "jaspar", "scpd", "cisbp",
    "psam", "xmatrix", "hocomoco"),
  to = c("auto", "pcm", "pfm", "pssm", "psam")
)
}
\arguments{
\item{filenames}{filename, 
an \link[TFBSTools:XMatrixList-class]{XMatrixList} object,
or an \link[TFBSTools:XMatrix-class]{XMatrix} object
to be imported.}

\item{format}{file format}

\item{to}{import to \link{pcm-class} or \link{pfm-class}}
}
\value{
a list of object \link{pcm-class} or \link{pfm-class}
}
\description{
Import the motifs into \link{pcm-class} or \link{pfm-class} from files
exported from Transfac, CisBP, and JASPAR.
}
\examples{

  path <- system.file("extdata", package = "motifStack")
  importMatrix(dir(path, "*.pcm", full.names = TRUE))

}
\author{
Jianhong Ou
}
\keyword{misc}
